<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class Contact extends Model
{
    use HasFactory;
    use Notifiable;

    protected $fillable = ['list_id', 'email', 'is_confirmed', 'is_verified', 'is_active', 'is_unsubscribed', 'source', 'app_id', 'user_id', 'is_bounced'];

    public function customFields()
    {
    return $this->belongsToMany('App\Models\CustomField', 'contact_custom_fields', 'contact_id', 'custom_field_id')->withPivot('data');
    }

    public function list()
    {
    return $this->belongsTo('App\Models\Lists', 'list_id');
    }

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
    return $query->where('app_id', \Auth::user()->app_id);
    }
}
