<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fbl extends Model
{
    use HasFactory;

    protected $fillable = ['email', 'is_active', 'is_validate', 'method', 'host', 'username', 'password', 'port', 'encryption', 'validate_cert', 'delete_after_processing', 'app_id', 'user_id'];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }
}
