<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrackingDomain extends Model
{
    use HasFactory;

    protected $fillable = ['domain', 'protocol', 'is_active', 'is_verified', 'auto_verification', 'app_id', 'user_id'];

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }

    public static function getTrackingDomains($return_type=null)
    {
        $domains = TrackingDomain::whereIsActive(true)->whereAppId(\Auth::user()->app_id);
        return $return_type == 'json' ? $domains->pluck('domain', 'id')->toJson() : $domains->select('id', 'domain', 'protocol')->get();
    }
}
