<?php

namespace App\Providers;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\ServiceProvider;

class ScheduleServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(Schedule $schedule): void
    {
        $schedule->command('run:campaigns')->everyMinute();
        $schedule->command('set:counter')->everyMinute();
        $schedule->command('execute:jobs')->everyMinute();
        $schedule->command('process:segmentation')->everyMinute();
        $schedule->command('relayzo:triggers')->everyMinute();
        $schedule->command('run:triggers-campaigns')->everyMinute();

        $schedule->command('set:open_clicks')->everyFifteenMinutes();

        $schedule->command('relayzo:cleaner')->daily();
        $schedule->command('relayzo:maintenance')->daily();

        // Add other schedules here
        // $schedule->call(fn() => \Log::info('Task executed'))->hourly();
        // $schedule->job(new YourJobClass)->daily();
    }
}
