<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedule_campaign_stats', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('schedule_campaign_id')->nullable();
            $table->string('schedule_campaign_name')->nullable();
            $table->string('email_subject')->nullable();
            $table->longText('content')->nullable();
            $table->string('schedule_by')->nullable();
            $table->unsignedTinyInteger('threads')->default(5);
            $table->unsignedInteger('total')->nullable();
            $table->unsignedInteger('scheduled')->nullable();
            $table->unsignedInteger('sent')->nullable();
            $table->json('opens_clicks')->nullable();
            $table->json('scheduled_detail')->nullable();
            $table->json('sending_speed')->nullable();
            $table->timestamp('start_datetime')->nullable();
            $table->timestamp('end_datetime')->nullable();
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedule_campaign_stats');
    }
};
