@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
@if($list_id)<script>loadListCustomFields('{{ $list_id }}');</script>@endif
<script>
(function () {
   'use strict';
   $("#list_ids").change(function () {
       var list_id = $('#list_ids').val();
       if(list_id == '') {
         $('#list_custom_fields').html('');
         return;
       }
       loadListCustomFields(list_id);
   });
})();
</script>
@endpush

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <label class="col-md-12"><h6 class="text-primary">{{__('app.general_info')}}</h6></label>
      <form method="POST" action="{{ route('contacts.store') }}" class="row g-3 mt-0 needs-validation" novalidate>
         @csrf       
         <div class="col-md-6 mt-1">
            <label class="form-label">{{__('app.list')}}
               <a href="{{ route('lists.create') }}">
                  <i class="bi bi-plus-circle-fill text-primary"></i>
               </a>
            </label>
            @include('includes.dropdown_lists', ['popup' => 0, 'multiselect' => 0, 'required' => 1, 'client_package_lists' => 0])
         </div>
         <div class="col-md-6 mt-1">
            <label class="form-label">{{__('app.email')}}</label>
            <input type="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ old('email') }}" name="email" required>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.active')}}</label>
            <select name="is_active" class="form-select form-select-lg">
               <option value="1">{{ __('app.yes') }}</option>
               <option value="0">{{ __('app.no')}}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.subscribed')}}</label>
            <select name="is_unsubscribed" class="form-select form-select-lg">
               <option value="0">{{ __('app.yes') }}</option>
               <option value="1">{{ __('app.no')}}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.confirmed')}}</label>
            <select name="is_confirmed" class="form-select form-select-lg">
               <option value="0">{{ __('app.no')}}</option>
               <option value="1">{{ __('app.yes') }}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.verified')}}</label>
            <select name="is_verified" class="form-select form-select-lg">
               <option value="0">{{ __('app.no')}}</option>
               <option value="1">{{ __('app.yes') }}</option>
            </select>
         </div>

         <label class="col-md-12 mt-5"><h6 class="text-primary">{{__('app.custom_fields')}}</h6></label>
         <div class="col-md-12" id="list_custom_fields">
            <label class="form-label">{{ __('app.no_custom_field') }}</label>
         </div>

         <div class="col-12">
            <button type="submit" name="save_exit" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_exit')}}</button>
            <button type="submit" name="save_continue" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_continue')}}</button>
            <a href="{{route('contacts.index')}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@endsection