@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
$(function() {
   'use strict';
   $("#lists").change(function () {
      $('#fields-mapping').hide();
      $('#btn-import').hide();
      $('#btn-proceed').show();
   });  
});
</script>
@endpush

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <label class="col-md-12"><h6 class="text-primary">{{__('app.general_info')}}</h6></label>
      <form method="POST" action="{{ route('contacts.store') }}" class="row g-3 mt-0 needs-validation" novalidate enctype="multipart/form-data">
         @csrf       
         <div class="col-md-6">
            <label class="form-label">{{__('app.list')}}
               <a href="{{ route('lists.create') }}">
                  <i class="bi bi-plus-circle-fill text-primary"></i>
               </a>
            </label>
            <select name="list_id" class="form-control" id="lists" required>
               <option value="">{{__('app.select_list')}}</option>
               @foreach(\App\Models\Lists::groupLists() as $group)
               <optgroup label="{{ $group->name }}">
                  @foreach($group->lists as $list)
                  <option value="{{ $list->id }}" {{ (isset($list_id) && $list->id == $list_id) ? 'selected="selected"' : '' }}>{{$list->name}} ({{$list->total_contacts ?? 0}})</option>
                  @endforeach
               </optgroup>
               @endforeach
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.file')}}</label>
            <input class="form-control" name="file" type="file" id="file" required>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.duplicates')}}</label>
            <select name="duplicates" class="form-select form-select-lg" id="duplicates">
               <option value="skip">{{ __('app.skip') }}</option>
               <option value="overwrite">{{ __('app.overwrite')}}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.active')}}</label>
            <select name="active" class="form-select form-select-lg" id="active">
               <option value="1">{{ __('app.yes') }}</option>
               <option value="0">{{ __('app.no')}}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.confirmed')}}</label>
            <select name="confirmed" class="form-select form-select-lg" id="confirmed">
               <option value="0">{{ __('app.no')}}</option>
               <option value="1">{{ __('app.yes') }}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.verified')}}</label>
            <select name="verified" class="form-select form-select-lg" id="verified">
               <option value="0">{{ __('app.no')}}</option>
               <option value="1">{{ __('app.yes') }}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.bounced')}}</label>
            <select name="bounced" class="form-select form-select-lg" id="bounced">
               <option value="allow">{{ __('app.allow') }}</option>
               <option value="skip">{{ __('app.skip')}}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.suppressed')}}</label>
            <select name="suppressed" class="form-select form-select-lg" id="suppressed">
               <option value="allow">{{ __('app.allow') }}</option>
               <option value="skip">{{ __('app.skip')}}</option>
            </select>
         </div>

         <div id="fields-mapping" style="display: none;">
            <label class="col-md-12 mt-3"><h6 class="text-primary">{{__('app.custom_fields')}}</h6></label>
            <div class="col-md-12" id="list-custom-fields">
               <label class="form-label">{{ __('app.no_custom_field') }}</label>
            </div>
         </div>

         <div class="box box-default" id="import-contacts" style="display: none;">
            <div class="box-header">
               <label class="col-md-12 col-form-label-lg mt-5">{{__('app.import')}}</label>
            </div>
            <div class="box-body" id="processing">
               <h6 class="text-info">{{ __('app.contact_import_msg') }}</h6>

               <div class="progress mb-3 progress-xl" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                  <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" style="width:0%">0%</div>
               </div>

               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.total') }}</label>
                  <div id="total" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.processed') }}</label>
                  <div id="processed" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.duplicates') }}</label>
                  <div id="duplicates-data" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.invalids') }}</label>
                  <div id="invalids" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.suppressed') }}</label>
                  <div id="suppressed-data" class="col-md-10">0</div>
               </div>
               <div class="row mb-3">
                  <label class="col-md-2 fw-medium">{{ __('app.bounced') }}</label>
                  <div id="bounced-data" class="col-md-10">0</div>
               </div>
            </div>
         </div>
         <!-- /.box-body -->

         <div class="col-12">
            <button type="button" class="btn btn-primary btn-loading" id="btn-proceed" onclick="contactsImport(this.form, '{{ route('contacts.import', ['id' => $list_id]) }}');"><i class=""></i> {{ __('app.proceed') }}</button>
            <button type="button" class="btn btn-primary btn-loading" id="btn-import" style="display: none;" onclick="doContactsImport(this.form, '{{ route('contacts.import', ['id' => $list_id]) }}')" id='exit'><i class=""></i> {{ __('app.import') }}</button>
            <a href="{{route('contacts.index')}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@endsection