@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<link rel="stylesheet" href="{{asset('components/jvectormap/jquery-jvectormap-2.0.3.css')}}">
<link rel="stylesheet" href="{{asset('components/bootstrap-daterangepicker/daterangepicker.css')}}">
<style>
    .dashboard-world-map{
        height: 280px; width: 100%; text-align: center;
    }
    #div-chart-domain{
        height: 250px; text-align: center;
    }
    #calendar {
        max-width: 100%;
    }
    .fc-event {
        cursor: pointer; /* Change cursor to a hand on hover */
    }
    #fc-dom-1 {
        font-size: 1.25rem; /* Matches the size of an h5 */
    }
</style>
@endsection

@push('scripts')
<script src="{{asset('components/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
<script src="{{asset('components/Chart.js/dist/Chart.min.js')}}"></script>
<script src="{{asset('components/jvectormap/jquery-jvectormap-2.0.3.min.js')}}"></script>
<script src="{{asset('components/jvectormap/jquery-jvectormap-world-mill-en.js')}}"></script>
<script src="{{asset('assets/js/fullcalander.min.js')}}"></script>
<script src="{{asset('assets/js/dashboard-calander.js')}}"></script>
<script src="{{asset('assets/js/dashboard.js')}}"></script>
<script>
    domiansChart(moment().subtract(7, 'days'), moment());
    countryChart(moment().subtract(7, 'days'), moment());
    campaignsChart(moment().subtract(7, 'days'), moment());
</script>
<script>
    $(function () {

    });
</script>
@endpush

@section('content')
<div id="domain" data-route="{{ route('campaigns.sent.data', ['type' => 'domain']) }}"></div>
<div id="recipients-summary" data-route="{{ route('campaigns.sent.data', ['type' => 'recipients_summary']) }}"></div>
<div id="country" data-route="{{ route('campaigns.sent.data', ['type' => 'country']) }}"></div>
<div id="campaign" data-route="{{ route('campaigns.sent.data', ['type' => 'campaigns']) }}"></div>
<div id="no-found" data-value="{{ __('app.no_record_found') }}"></div>
<div id="opens" data-value="{{ __('app.opens')}}"></div>
<div id="data-campaigns-route" data-value="{{ route('stats.campaigns') }}"></div>
<div id="schedule-campaigns-msg" data-value="{{ __('app.schedule_campaigns_msg') }}"></div>

@if(Auth::user()->id == config('custom.app_id'))
    @if(file_exists(public_path().DIRECTORY_SEPARATOR.'install'))
    <div class="row my-2">
        <div class="col-md-12 col-sm-12 col-xs-12 text-center">
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle"></i>
                {!! __('app.msg_remove_install_folder') !!}
                "{{public_path().DIRECTORY_SEPARATOR.'install'}}"
            </div>
        </div>
    </div>
    @endif
    <!-- Display warning if cron executed more than 3 minutes -->
    @if(\App\Http\Helper\Helper::getCronLatExecutedMinutes() > 3)
    <div class="row my-2">
        <div class="col-md-12 col-sm-12 col-xs-12 text-center">
            <div class="alert alert-danger" role="alert">
                <i class="bi bi-exclamation-triangle"></i>
                {!! __('app.msg_cron_setup') !!}:<strong><br>
                {{ \App\Http\Helper\Helper::getCronCommand() }}</strong>
            </div>
        </div>
    </div>
    @endif
    @if(empty($settings->from_email))
    <div class="row my-2">
        <div class="col-md-12 col-sm-12 col-xs-12 text-center">
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle"></i>
                {!! __('app.msg_configure_mail_setting') !!}
            </div>
        </div>
    </div>
    @endif
@endif

@if(\App\Http\Helper\Helper::checkPermissions('dashboard_cards', false))
<div class="row mt-2">
    <div class="col-md-6 col-lg-4 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body">
                <div class="">
                    <div class="d-flex justify-content-between mb-2">
                        <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-pill">
                            <span class="avatar avatar-md avatar-rounded bg-primary svg-white">
                                <i class="bi bi-list-task"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-14 mb-0">{{__('app.total_lists')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between mt-1">
                    <h4 class="mb-0 d-flex align-items-center">{{ \App\Models\Lists::app()->count() }}</h4>
                    <span class="text-primary badge bg-primary-transparent rounded-pill d-flex align-items-center fs-11 me-0 ms-2 mb-0"> <a class="text-primary" href="{{route('lists.create')}}">{{__('app.add_new_list')}}</a></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-lg-4 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body">
                <div class="">
                    <div class="d-flex justify-content-between mb-2">
                        <div class="p-2 border border-primary1 border-opacity-10 bg-primary1-transparent rounded-circle">
                            <span class="avatar avatar-rounded avatar-md bg-primary1 svg-white">
                                <i class="bi bi-people"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-14 mb-0">{{__('app.total_contacts')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between mt-1">
                    <h4 class="mb-0 d-flex align-items-center">{{ \App\Models\Contact::app()->count() }}</h4>
                    <span class="text-primary1 badge bg-primary1-transparent rounded-pill d-flex align-items-center fs-11 me-0 ms-2 mb-0"><a class="text-primary1" href="{{route('contacts.create')}}">{{__('app.add_new_contact')}}</a></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-lg-4 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body">
                <div class="">
                    <div class="d-flex justify-content-between mb-2">
                        <div class="p-2 border border-info border-opacity-10 bg-info-transparent rounded-circle">
                            <span class="avatar avatar-rounded avatar-md bg-info svg-white">
                                <i class="bi bi-send"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-14 mb-0">{{__('app.running_campaigns')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between mt-1">
                    <h4 class="mb-0 d-flex align-items-center">{{ \App\Models\ScheduleCampaign::getRunningCampaing() }}</h4>
                    <span class="text-info badge bg-info-transparent rounded-pill d-flex align-items-center fs-11 me-0 ms-2 mb-0"><a class="text-info" href="{{route('schedule_campaigns.create')}}">{{__('app.schedule_campaign')}}</a></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-lg-6 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body">
                <div class="">
                    <div class="d-flex justify-content-between mb-2">
                        <div class="p-2 border border-primary3 border-opacity-10 bg-primary3-transparent rounded-circle">
                            <span class="avatar avatar-rounded avatar-md bg-primary3 svg-white">
                                <i class="bi bi-rocket-takeoff"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-14 mb-0">{{__('app.active_delivery_servers')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between">
                    <div class="fs-22 fw-medium mb-0 d-flex align-items-center">{{ \App\Models\SendingServer::whereStatus('Active')->app()->count() }}</div>
                    <span class="text-primary3 badge bg-primary3-transparent rounded-pill d-flex align-items-center fs-11 me-0 ms-2 mb-0"><a class="text-primary3" href="{{route('sending_servers.create')}}">{{__('app.add_new_delivery_server')}}</a></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12 col-lg-6 col-xl">
        <div class="card custom-card crm-card">
            <div class="card-body">
                <div class="">
                    <div class="d-flex justify-content-between mb-2">
                        <div class="p-2 border border-secondary border-opacity-10 bg-secondary-transparent rounded-circle">
                            <span class="avatar avatar-rounded avatar-md bg-secondary svg-white">
                                <i class="bi bi-globe"></i>
                            </span>
                        </div>
                    </div>
                    <p class="flex-fill fs-14 mb-0">{{__('app.active_sending_domains')}}</p>
                </div>
                <div class="d-flex align-items-center justify-content-between mt-1">
                    <h4 class="mb-0 d-flex align-items-center">{{ \App\Models\SendingDomain::whereIsActive(true)->app()->count() }}</h4>
                    <span class="text-secondary badge bg-secondary-transparent rounded-pill d-flex align-items-center fs-11 me-0 ms-2 mb-0"><a class="text-secondary" href="javascript:;" onclick="viewModal('modal', '{{route('sending_domains.create')}}');">{{__('app.add_new_sending_domain')}}</a></span>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
<div class="card custom-card">
    <div class="card-body">
        <div class="row">
            @if(\App\Http\Helper\Helper::checkPermissions('dashboard_calander', false))
            <div class="col-md-5">
                <div id="calendar" class="shadow p-3 rounded"></div>
            </div>
            @endif
            @if(\App\Http\Helper\Helper::checkPermissions('dashboard_campaigns_stats', false))
            <div class="col-md-7 p-3">                
                <div class="card custom-card">
                    <div class="card-body">
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <h5>{{ __('app.campaigns') }}</h5>
                                <button type="button" class="btn btn-primary btn-sm daterange-campaigns" data-toggle="tooltip" title="Date range">
                                    <i class="bi bi-calendar"></i>
                                </button>
                                <small id="campaigns-range"></small>

                                <div class="chart">
                                    <div id="div-chart-campaigns"></div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@if(\App\Http\Helper\Helper::checkPermissions('analatics_campaigns', false))
<div class="card custom-card">
    <div class="card-body">
        <h5>{{ __('app.analatics') }}</h5>
        <div class="table-responsive">
            <table id="data" class="table table-bordered text-nowrap w-100">
                <thead>
                    <tr>
                        <th>{{ __('app.name') }}</th>
                        <th>{{ __('app.started_at') }}</th>
                        <th>{{ __('app.total') }}</th>
                        <th>{{ __('app.scheduled') }}</th>
                        <th>{{ __('app.sent') }}</th>
                        <th>{{ __('app.opens') }}</th>
                        <th>{{ __('app.clicks') }}</th>
                        <th>{{ __('app.created') }}</th>
                        <th>{{ __('app.detail') }}</th>
                        <th>{{ __('app.action') }}</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>
@endif

<div class="card custom-card">
    <div class="card-body">
        <div class="row">
            @if(\App\Http\Helper\Helper::checkPermissions('dashboard_country_stats', false))
            <div class="col-md-8" >
                <h5>{{ __('app.open_by_countries') }}</h5>
                <button type="button" class="btn btn-primary btn-sm daterange-country" data-toggle="tooltip" title="Date range">
                    <i class="bi bi-calendar"></i>
                </button>
                <small id="country-range"></small>
                <div id="world-map" class="dashboard-world-map"></div>
            </div>
            @endif
            @if(\App\Http\Helper\Helper::checkPermissions('dashboard_domain_stats', false))
            <div class="col-md-4">
                <h5>{!! __('app.top_5_domains') !!} </h5>
                <button type="button" class="btn btn-primary btn-sm daterange-domain pull-right" data-toggle="tooltip" title="Date range">
                    <i class="bi bi-calendar"></i>
                </button>
                <small id="domain-range"></small>
                <div class="chart dashboard-world-map">
                    <div id="div-chart-domain"></div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@include('includes.datatables')
@endsection
