@extends('layouts.app')
@section('title', $page_title)

@section('content')
<div class="card custom-card">
  <div class="card-body">
    <form method="POST" action="{{ route('fbls.store') }}" class="row g-3 mt-0 needs-validation" novalidate>
      @csrf       
      <div class="col-md-6">
        <label class="form-label">{{__('app.email')}}</label>
        <input type="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ old('email') }}" name="email" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.status')}}</label>
        <select name="is_active" class="form-select form-select-lg">
          <option value="1">{{ __('app.active')}}</option>
          <option value="0">{{ __('app.in_active') }}</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.method')}}</label>
        <select name="method" class="form-select form-select-lg">
          <option value="imap">IMAP</option>
          <option value="pop3">POP3</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.host')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.host')}}" value="{{ old('host') }}" name="host" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.username')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.username')}}" value="{{ old('username') }}" name="username" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.password')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.password')}}" value="{{ old('password') }}" name="password" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.port')}}</label>
        <input type="number" class="form-control" placeholder="{{__('app.port')}}" value="{{ old('port') }}" name="port" required min="0">
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.encryption')}}</label>
        <select name="encryption" class="form-select form-select-lg">
          <option value="none">None</option>
          <option value="ssl">SSL</option>
          <option value="tls">TLS</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.validate_cert')}}</label>
        <select name="validate_cert" class="form-select form-select-lg">
          <option value="Yes">{{ __('app.yes') }}</option>
          <option value="No">{{ __('app.no') }}</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.delete_after_processing')}}</label>
        <select name="delete_after_processing" class="form-select form-select-lg">
          <option value="No">{{ __('app.no') }}</option>
          <option value="Yes">{{ __('app.yes') }}</option>
        </select>
      </div>
      <div class="col-12">
        <button type="submit" name="save_exit" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_exit')}}</button>
        <button type="submit" name="save_continue" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_continue')}}</button>
        <a href="{{route('fbls.index')}}">
        <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button></a>
        <button type="submit" name="save_validate" value="1" class="btn btn-info btn-loading"><i class=""></i> {{__('app.save_validate')}}</button>
      </div>
    </form>
  </div>
</div>
@endsection