@extends('layouts.app')
@section('title', $page_title)

@section('content')
<div class="card custom-card">
  <div class="card-body">
    <form method="POST" action="{{ route('fbls.update', $fbl->id) }}" class="row g-3 mt-0 needs-validation" novalidate>
      @csrf
      @method('PUT')
      <div class="col-md-6">
        <label class="form-label">{{__('app.email')}}</label>
        <input type="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ $fbl->email }}" name="email" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.status')}}</label>
        <select name="is_active" class="form-select form-select-lg">
          <option value="1" {{ $fbl->is_active ? 'selected' : '' }}>{{ __('app.active')}}</option>
          <option value="0" {{ $fbl->is_active ? '' : 'selected' }}>{{ __('app.in_active') }}</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.method')}}</label>
        <select name="method" class="form-select form-select-lg">
          <option value="imap" {{ $fbl->method == 'imap' ? 'selected' : '' }}>IMAP</option>
          <option value="pop3" {{ $fbl->method == 'pop3' ? 'selected' : '' }}>POP3</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.host')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.host')}}" value="{{ $fbl->host }}" name="host" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.username')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.username')}}" value="{{ $fbl->username }}" name="username" required>
      </div>
      <div class="col-md-6 position-relative">
        <label class="form-label">{{__('app.password')}}</label>
        <input id="password" type="password" class="form-control" placeholder="{{__('app.password')}}" name="password" value="{{Crypt::decrypt($fbl->password)}}">
        <a href="javascript:void(0);" class="show-password-button text-muted" onclick="createpassword('password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle"></i></a>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.port')}}</label>
        <input type="number" class="form-control" placeholder="{{__('app.port')}}" value="{{ $fbl->port }}" name="port" required min="0">
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.encryption')}}</label>
        <select name="encryption" class="form-select form-select-lg">
          <option value="none" {{ $fbl->encryption == 'none' ? 'selected' : '' }}>None</option>
          <option value="ssl" {{ $fbl->encryption == 'ssl' ? 'selected' : '' }}>SSL</option>
          <option value="tls" {{ $fbl->encryption == 'tls' ? 'selected' : '' }}>TLS</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.validate_cert')}}</label>
        <select name="validate_cert" class="form-select form-select-lg">
          <option value="Yes" {{ $fbl->validate_cert == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
          <option value="No" {{ $fbl->validate_cert == 'No' ? 'selected' : '' }}>{{ __('app.no') }}</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.delete_after_processing')}}</label>
        <select name="delete_after_processing" class="form-select form-select-lg">
          <option value="No" {{ $fbl->delete_after_processing == 'No' ? 'selected' : '' }}>{{ __('app.no') }}</option>
          <option value="Yes" {{ $fbl->delete_after_processing == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
        </select>
      </div>
      <div class="col-12">
        <input type="hidden" name="id" value="{{$fbl->id}}">
        <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
        <a href="{{route('fbls.index')}}">
        <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button></a>
        <button type="button" id="validate-imap" onclick="validateImap(this.form, '{{route('validateFblImap')}}')" class="btn btn-info btn-loading"><i class=""></i> {{__('app.validate')}}</button>
        <span id="imap-msg" class="mx-3"></span>
      </div>
    </form>
  </div>
</div>
@endsection