@extends('layouts.app')
@section('title', $page_title)

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('packages.store') }}" class="row g-3 mt-0 needs-validation" novalidate>
         @csrf
         <div class="col-md-12">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}"
            aria-label="{{__('app.name')}}" value="{{ old('name') }}"  name="name" required>
         </div>
         <div class="col-md-12">
           <label class="form-label">{{__('app.detail')}}</label>
           <textarea class="form-control" placeholder="{{__('app.detail')}}" row="3" name="description">{{ old('description') }}</textarea>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.contact_limit')}}</label>
            <small>({{__('app.minus_1_unlimited')}})</small>
            <input type="number" class="form-control" name="no_of_contacts"  value="{{ old('no_of_contacts') ?? -1 }}" min = '-1'>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.sending_server_limit')}}</label>
            <small>({{__('app.minus_1_unlimited')}})</small>
            <input type="number" class="form-control" name="no_of_sending_servers"  value="{{ old('no_of_sending_servers') ?? -1 }}">
         </div>
         <div class="col-md-12 mt-3">
           <label class="form-label">{{__('app.lists')}}
             <a tabindex="-1" role="button"
             data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
             data-bs-content="{{__('app.packages_lists')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
             </a>
           </label>
           @include('includes.dropdown_lists', ['popup' => 0, 'multiple' => 1])
         </div>
         <div class="col-md-12 mt-3">
           <label class="form-label">{{__('app.delivery_servers')}}
             <a tabindex="-1" role="button"
             data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
             data-bs-content="{{__('app.packages_delivery_servers')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
             </a>
           </label>
           @include('includes.dropdown_sending_server', ['popup' => 0, 'multiple' => 1])
         </div>
         <div class="col-12">
            <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.create')}}</button>
            <a href="{{route('packages.index')}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@endsection
