@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<link href="{{asset('assets/css/smart_wizard_all.min.css')}}" rel="stylesheet" >
<link href="{{asset('assets/css/schedule.css')}}" rel="stylesheet" >
@endsection

@push('scripts')
<script src="{{asset('components/ckeditor/ckeditor.js')}}"></script>
<script src="{{asset('components/ckeditor/plugins/mc_uploader/plugin.js')}}"></script>
<script src="{{asset('assets/js/campaign.js')}}"></script>
<script src="{{asset('assets/js/jquery.smartWizard.min.js')}}"></script>
<script src="{{asset('assets/js/schedule.js')}}"></script>
@endpush

@section('content')
<div class="card custom-card">
  <div class="card-body">
    <form id="frm-schedule" method="POST" action="{{ route('schedule_campaigns.update', $schedule->id) }}" class="row g-3 mt-0 needs-validation" novalidate>
      @csrf
      @method('PUT')  
      <!-- SmartWizard html -->
      <div id="smartwizard">
        <ul class="nav nav-progress">
          <li class="nav-item">
            <a class="nav-link" href="#step-1">
              <div class="num">1</div>
              {{__('app.basic_info')}}
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-2" data-route="{{route('broadcasts.edit', [0])}}">
              <span class="num">2</span>
              {{__('app.campaign_detail')}}
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-3">
              <span class="num">3</span>
              {{__('app.settings')}}
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-4">
              <div class="num">4</div>
              {{__('app.review')}}
            </a>
          </li>
        </ul>

        <div class="tab-content">
          <div id="step-1" class="tab-pane" role="tabpanel" aria-labelledby="step-1">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{$schedule->name}}" id="name" name="name" required>
            <div class="col-md-12 mt-3">
              <label class="form-label">{{__('app.lists')}}
                <a href="{{route('lists.create')}}" tabindex="-1">
                  <i class="bi bi-plus-circle-fill text-primary"></i>
                </a>
                <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
                data-bs-content="{{__('app.schedule_lists')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
                </a>
              </label>
              @php $list_ids = explode(',', $schedule->list_ids);  @endphp
              @include('includes.dropdown_lists', ['popup' => 0, 'multiple' => 1, 'required' => 1, 'client_package_lists' => 1])
            </div>                   
            <div class="col-md-12 mt-3">
              <label class="form-label">{{__('app.delivery_servers')}}
                <a href="{{route('sending_servers.create')}}" tabindex="-1">
                  <i class="bi bi-plus-circle-fill text-primary"></i>
                </a>
                <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
                data-bs-content="{{__('app.schedule_delivery_servers')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
                </a>
              </label>
              @php $sending_server_ids = explode(',', $schedule->sending_server_ids);  @endphp
              @include('includes.dropdown_sending_server', ['popup' => 0, 'multiple' => 1, 'required' => 1])
            </div>
            <div class="col-md-12 mt-3">
              <label class="form-label">{{__('app.from_detail')}}</label><br>
              <input name="from_detail" class="form-check-input ms-2" type="radio" checked="checked" value="sending_server" {{ $schedule->from_detail == 'sending_server' ? 'checked' : '' }}> {{__('app.as_defined_for_sending_server')}} &nbsp;
              <input name="from_detail" class="form-check-input ms-2" type="radio" value="list" {{ $schedule->from_detail == 'list' ? 'checked' : '' }}> {{__('app.as_defined_for_list')}} &nbsp;
              <input name="from_detail" class="form-check-input ms-2" type="radio" value="custom" {{ $schedule->from_detail == 'custom' ? 'checked' : '' }}> {{__('app.custom')}}
            </div>
            <div class="row mt-3" id="custom_email_data" style="{{ $schedule->from_detail == 'custom' ? '' : 'display: none;' }}">
              @php
              if($schedule->from_detail == 'custom') {
                $form_detail_custom = json_decode($schedule->from_detail_custom);
                $from_email_domain = explode('@', $form_detail_custom->from_email)[1];
              }
              @endphp
              <div class="col-md-3">
                 <input type="text" id="from_name" class="form-control" placeholder="{{__('app.from_name')}}" value="{{$form_detail_custom->from_name ?? ''}}" name="from_name">
              </div>
              <div class="col-md-5">
                 <div class="input-group">
                    <div style="width: 35%;">
                      <input type="text" id="from_email_part1" name="from_email_part1" value="{{($schedule->from_detail == 'custom') ? strstr($form_detail_custom->from_email, '@', true) : ''}}" class="form-control" placeholder="{{__('app.from_email_example')}}">
                    </div>
                    <span class="input-group-text">@</span>
                    <select name="from_email_part2" class="form-select" id="from_email_part2">
                      <option value="">{{__('app.select_domain')}}</option>
                      @foreach(\App\Models\SendingDomain::getSendingDomains() as $sending_domain)
                        <option value="{{ $sending_domain->domain }}" {{ ($schedule->from_detail == 'custom' && $from_email_domain == $sending_domain->domain) ? 'selected="selected"' : '' }}>{{ $sending_domain->domain }}</option>
                      @endforeach
                    </select>
                  </div>
              </div>
              <div class="col-md-4">
                 <input type="email" id="reply_email" class="form-control" placeholder="{{__('app.reply_email')}}" value="{{$form_detail_custom->reply_email ?? ''}}" name="reply_email">
              </div>
            </div>

          </div>
          <div id="step-2" class="tab-pane" role="tabpanel" aria-labelledby="step-2">
            <div class="col-md-12">
            <label class="form-label">{{__('app.subject')}}</label>
            <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.subject')}}"
            data-bs-content="{{__('app.subject_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
            </a>
         <input type="text" class="form-control" placeholder="{{__('app.subject')}}" value="{{$schedule->email_subject ?? ''}}" name="email_subject" id="email_subject">
         </div>

         <div class="col-md-12 mt-3">
            <label class="form-label">{{__('app.content')}} <span class="ps-5"></span></label>
            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('shortcodes') }}');" tabindex="-1">{{ __('app.shortcodes') }}</button><span class="ps-1"></span>
            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('broadcasts.all') }}');" tabindex="-1">Import Campaigns</button><span class="ps-1"></span>
            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('templates.all') }}');" tabindex="-1">Import Template</button> 
            <textarea class="form-control" id="content_html" name="content_html" rows="10">{{\App\Http\Helper\Helper::decodeString($schedule->content) }}</textarea>
         </div>
          </div>

          <div id="step-3" class="tab-pane" role="tabpanel" aria-labelledby="step-3">
            <div class="col-md-12 mt-3">
              <label class="form-label">{{ __('app.send') }}</label>
              <select name="send" id="send" class="form-select">
                <option value="now" {{$schedule->send == 'now' ? 'selected' : ''}}>{{ __('app.now') }}</option>
                <option value="later" {{$schedule->send == 'later' ? 'selected' : ''}}>{{ __('app.later') }}</option>
              </select>
            </div>

            <div class="col-md-12 mt-3" id="send-datetime" style="{{$schedule->send == 'later' ? '' : 'display: none;'}}">
              <label class="form-label">{{ __('app.sending_datetime') }}</label>
              <div class="form-group">
                <div class="input-group">
                  <div class="input-group-text text-muted"> <i class="ri-calendar-line"></i> </div>
                  <input type="text" value="{{ \App\Http\Helper\Helper::datetimeDisplay($schedule->send_datetime) ?? ''}}" name="send_datetime" class="form-control" id="send_datetime" placeholder="{{ __('app.choose_date_time') }}">
                  <input type="hidden" name="db_send_datetime" id="db_send_datetime" value="{{ \App\Http\Helper\Helper::datetimeDisplay($schedule->send_datetime) ?? ''}}">
                  <input type="hidden" name="timezone" id="timezone" value="{{ \Auth::user()->timezone }}" >
                </div>
              </div>
            </div>

            <div class="col-md-12 mt-3">
              <label class="col-md-2 form-label">{{ __('app.sending_speed') }}</label>
              <select name="speed" id="speed" class="form-select">
                <option value="unlimited" {{ json_decode($schedule->sending_speed)->speed == 'unlimited' ? 'selected="selected"' : '' }}>{{ __('app.unlimited') }}</option>
                <option value="limited" {{ json_decode($schedule->sending_speed)->speed == 'limited' ? 'selected="selected"' : '' }}>{{ __('app.limited') }}</option>
              </select>
            </div>

            <div class="row" id="speed-attributes" style="{{ json_decode($schedule->sending_speed)->speed == 'limited' ? '' : 'display: none;' }}">
            <div class="col-md-6 mt-3" >
                <input type="number" class="form-control" name="limit" id="limit" value="{{ json_decode($schedule->sending_speed)->limit }}" min="1" placeholder="1000">
            </div>
            <div class="col-md-6 mt-3" >
                <select name="duration" id="duration" class="form-control" >
                  <option value="hour" {{ json_decode($schedule->sending_speed)->duration == 'hour' ? 'selected="selected"' : '' }}>{{ __('app.hourly') }}</option>
                </select>
            </div>
          </div>

          </div>

          <div id="step-4" class="tab-pane" role="tabpanel" aria-labelledby="step-4">
            <h3>{{ __('app.review') }}</h3>
            <div id="review-section"></div>
            <p><strong>{{ __('app.lists') }}:</strong> <span id="review-lists"></span></p>
            <p><strong>{{ __('app.delivery_servers') }}:</strong> <span id="review-sending-servers"></span></p>
          </div>

        </div>
      </div>
      <input type="hidden" name="operation" id="operation" value="">
    </form>
  </div>
</div>
@endsection