@extends('layouts.app')
@section('title', __('app.sending_domain_detil'))

@push('scripts')
<script>
  $(document).on('click', '.bi-copy', function() {
    // Find the nearest input field within the same input group
    var inputVal = $(this).closest('.input-group').find('input').val();
    
    // Create a temporary input element to hold the value
    var tempInput = $('<input>');
    $('body').append(tempInput);
    tempInput.val(inputVal).select();
    
    // Copy the value to the clipboard
    document.execCommand('copy');
    
    // Remove the temporary input element
    tempInput.remove();
    toastr.success('Copied successfully!');
});
</script>
@endpush

@section('content')
<div class="card custom-card">
  <div class="card-body">
    <form method="POST" action="{{route('sending_domains.update', $sending_domain->id)}}" class="row g-3 mt-0 needs-validation" novalidate>
      @csrf
      @method('PUT')   
      <div class="col-md-2">
        <select name="protocol" class="form-select form-select-lg">
          <option value="https://" {{ $sending_domain->protocol == 'https://' ? 'selected' : '' }}>https://</option>
          <option value="http://" {{ $sending_domain->protocol == 'http://' ? 'selected' : '' }}>http://</option>
        </select>
      </div>
      <div class="col-md-10 col-form-label">
        <h6>{{$sending_domain->domain}}</h6>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.group')}}
          <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_sending_domains')])}}');" tabindex="-1">
            <i class="bi bi-plus-circle-fill text-primary"></i>
          </a>
        </label>
        <select name="group_id" class="single-select" id="group_id" required>
          @foreach($groups as $id => $group_name)
          <option value="{{ $id }}" {{ $sending_domain->group_id == $id ? 'selected' : '' }}>{{$group_name}}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">{{__('app.active')}}</label>
        <select name="is_active" class="form-select form-select-lg">
          <option value="1" {{ $sending_domain->is_active ? 'selected' : '' }}>{{ __('app.yes')}}</option>
          <option value="0" {{ $sending_domain->is_active ? '' : 'selected' }}>{{ __('app.no') }}</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">{{__('app.auto_verification')}}
          <a tabindex="-1" role="button"
          data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.auto_verification')}}"
          data-bs-content="{{__('app.domain_auto_verfication_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
          </a>
        </label>
        <select name="auto_verification" class="form-select form-select-lg">
          <option value="0" {{ $sending_domain->auto_verification ? '' : 'selected' }}>{{ __('app.no')}}</option>
          <option value="1" {{ $sending_domain->auto_verification ? 'selected' : '' }}>{{ __('app.yes') }}</option>
        </select>
      </div>
      <div class="col-md-12">
        <lable class='text-danger'>{{__('app.alert_keys_dns_values')}}</lable>
      </div>
      <div class="col-md-12">
        <h6>{{__('app.keys')}} &nbsp;<a tabindex="-1" href="{{ route('download.keys', ['id' => $sending_domain->id]) }}"><i class="bi bi-download text-primary" title="Download"></i></a></h6>
      </div>
      <div class="col-md-12">
        <label class="form-label">{{__('app.public_key')}}</label>
        <textarea class="form-control" name="public_key" rows="3">{{$sending_domain->public_key}}</textarea>
      </div>
      <div class="col-md-12">
        <label class="form-label">{{__('app.private_key')}}</label>
        <textarea class="form-control" name="private_key" rows="3">{{$sending_domain->private_key}}</textarea>
      </div>
      <div class="col-md-12 mt-4">
        <h6>{{__('app.dns_entries')}}</h6>
      </div>
      <div class="col-md-12">
        <lable>
          {!! str_replace('[domain-name]', $sending_domain->domain , __('app.help_dns_entries')) !!}
        </lable>
      </div>

      <div class="col-md-1 fw-bold">{{__('app.type')}}</div>
      <div class="col-md-4 fw-bold">{{__('app.host')}}</div>
      <div class="col-md-6 fw-bold">{{__('app.value')}}</div>
      <div class="col-md-1 fw-bold">{{__('app.verified')}}</div>

      <div class="col-md-1">TXT</div>
      <div class="col-md-4">
        <div class="input-group">
          <input type="text" class="form-control" name="host_dkim" value="{{$sending_domain->host_dkim}}">
          <div class="input-group-text">
            <a href="javascript:;" tabindex="-1"><i class="bi bi-copy text-primary"></i></a>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="input-group">
          <input type="text" class="form-control" name="value_dkim" value="{{$sending_domain->value_dkim}}">
          <div class="input-group-text">
            <a href="javascript:;" tabindex="-1"><i class="bi bi-copy text-primary"></i></a>
          </div>
        </div>
      </div>
      <div class="col-md-1 mt-4">
        <span id="key-{{$sending_domain->id}}" class="badge {{ $sending_domain->is_verified_key ? 'bg-success' : 'bg-danger' }}"><i class="bi {{ $sending_domain->is_verified_key ? 'bi-check-lg' : 'bi-x-lg' }}"></i></span>
      </div>

      <div class="col-md-1">TXT</div>
      <div class="col-md-4">
        <div class="input-group">
          <input type="text" class="form-control" name="host_spf" value="{{$sending_domain->host_spf}}">
          <div class="input-group-text">
            <a href="javascript:;" tabindex="-1"><i class="bi bi-copy text-primary"></i></a>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="input-group">
          <input type="text" class="form-control" name="value_spf" value="{{$sending_domain->value_spf}}">
          <div class="input-group-text">
            <a href="javascript:;" tabindex="-1"><i class="bi bi-copy text-primary"></i></a>
          </div>
        </div>
      </div>
      <div class="col-md-1 mt-4">
        <span id="spf-{{$sending_domain->id}}" class="badge {{ $sending_domain->is_verified_spf ? 'bg-success' : 'bg-danger' }}"><i class="bi {{ $sending_domain->is_verified_spf ? 'bi-check-lg' : 'bi-x-lg' }}"></i></span>
      </div>

      <div class="col-md-1">TXT</div>
      <div class="col-md-4">
        <div class="input-group">
          <input type="text" class="form-control" name="host_dmarc" value="{{$sending_domain->host_dmarc}}">
          <div class="input-group-text">
            <a href="javascript:;" tabindex="-1"><i class="bi bi-copy text-primary"></i></a>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="input-group">
          <input type="text" class="form-control" name="value_dmarc" value="{{$sending_domain->value_dmarc}}">
          <div class="input-group-text">
            <a href="javascript:;" tabindex="-1"><i class="bi bi-copy text-primary"></i></a>
          </div>
        </div>
      </div>
      <div class="col-md-1 mt-4">
        <span id="dmarc-{{$sending_domain->id}}" class="badge {{ $sending_domain->is_verified_dmarc ? 'bg-success' : 'bg-danger' }}"><i class="bi {{ $sending_domain->is_verified_dmarc ? 'bi-check-lg' : 'bi-x-lg' }}"></i></span>
      </div>

      <div class="col-12">
        <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
        <a href="{{route('sending_domains.index')}}">
          <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
        </a>
        <button type="button" class="btn btn-info btn-loading" onclick="validateDomain('{{$sending_domain->id}}')"><i class=""></i> {{__('app.validate')}}</button>
      </div>
    </form>
  </div>
</div>
@include('includes.modal')
@endsection