@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script src="{{asset('assets/js/suppression.js')}}"></script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <a href="javascript:;" onclick="viewModal('modal', '{{route('suppressions.create')}}');"><button id="addRow" class="btn btn-primary" style="margin: 0px; display: none;">{{__('app.add_suppression')}}</button></a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle btn-sm" data-bs-toggle="dropdown" aria-expanded="false">{{__('app.actions')}}</button>
                                <ul class="dropdown-menu" style="">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('suppressions.destroy', [0]) }}')"><i class="bi bi-trash"></i> {{ __('app.delete') }}</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.email') }}</th>
                                <th>{{ __('app.group') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-suppression" data-route="{{ route('get.suppressions') }}"></span>
<input type="hidden" id="route-group-delete-list" value="{{ route('group.delete', ['model' => 'suppression']) }}">
<span id="route-group-edit" data-route="{{ route('groups.edit', 'group-id') }}"></span>
<span id="tooltip-group-edit" data-value="{{ __('app.tooltip_group_edit') }}"></span>
<span id="tooltip-group-delete-list" data-value="{{ __('app.tooltip_group_delete_list') }}"></span>
<span id="msg-group-delete-list" data-value="{{ __('app.msg_group_delete_list') }}"></span>
<span id="tooltip-group-eraser-list" data-value="{{ __('app.tooltip_group_eraser_list') }}"></span>
<span id="route-group-eraser-list" data-route="{{ route('group.delete', ['model' => 'suppression']) }}"></span>
<span id="msg-group-erase-list" data-value="{{ __('app.msg_group_eraser_list') }}"></span>
@include('groups.move')
@include('includes.datatables')
@endsection
