<script src="{{asset('assets/js/app.js')}}"></script>
<script src="{{asset('assets/js/update.js')}}"></script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
	<div class="modal-content">
		<form>
			<div class="modal-header">
				<h6 class="modal-title" id="staticBackdropLabel">{{__('app.update')}}
				</h6>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
			</div>
			<div class="modal-body">
				<div class="box-body">
					<div class="row pt-3">
						<label class="form-label col-md-4">{{__('app.license_key')}}: </label>
						<label class="col-md-8">{{ $settings->license_key }}</label>
					</div>
					<div class="row">
						<label class="form-label col-md-4">{{__('app.application_version')}}: </label>
						<label class="col-md-8">{{ $settings->current_version }}</label>
					</div>
					<div class="row">
						<label class="form-label col-md-4">{{__('app.available_version')}}: </label>
						<label class="col-md-8">{{ $settings->available_version }}</label>
					</div>
					@if($settings->available_version > $settings->current_version)
					<div class="col-md-12 pt-3">
						<h6 class="text-warning">{{__('app.latest_version_msg')}}</h6>
					</div>
					@else
					<div class="col-md-12 pt-3">
						<h6 class="text-success">{{__('app.already_latest_version_msg')}}</h6>
					</div>
					@endif
					<div class="col-md-12 pt-3">
						<strong>{!!__('app.change_log')!!}</strong>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<span id="msg"></span>
				<button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('app.close')}}</button>
				@if($settings->available_version > $settings->current_version)
				<button type="button" id="btn-update" class="btn btn-primary btn-loading" data-route="{{ route('update.app') }}"><i class=""></i> {{__('app.update')}}</button>
				@endif
			</div>
		</form>
	</div>
</div>
<span id="update-proceed-msg" data-value="{{ __('app.update_proceed_msg') }}"></span>
<span id="update-warning-msg" data-value="{{ __('app.update_warning_msg') }}"></span>