<script src="{{asset('assets/js/app.js')}}"></script>

<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <form id="frm-group" method="post" action="{{route('tracking_domains.update', $tracking_domain->id)}}" class="needs-validation" novalidate>
        @csrf
        @method('PUT')
        <div class="modal-header">
          <h6 class="modal-title">{{__('app.edit_tracking_domain')}}</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <div class="box-body">
            <div class="row">
            <div class="col-md-3">
              <label class="form-label">{{__('app.protocol')}}</label>
              <select name="protocol" class="form-select form-select-lg">
                 <option value="https://" {{ $tracking_domain->protocol == 'https://' ? 'selected' : '' }}>https://</option>
                 <option value="http://" {{ $tracking_domain->protocol == 'http://' ? 'selected' : '' }}>http://</option>
              </select>
            </div>
            <div class="col-md-9">
              <label class="form-label">{{__('app.domain')}}</label>
              <input type="text" class="form-control" placeholder="{{__('app.domain')}}" value="{{$tracking_domain->domain}}" name="domain" required>
            </div>
            <div class="col-md-4 mt-3">
              <label class="form-label">{{__('app.active')}}</label>
              <select name="is_active" class="form-select form-select-lg">
                 <option value="1" {{ $tracking_domain->is_active ? 'selected' : '' }}>{{ __('app.yes')}}</option>
                 <option value="0" {{ $tracking_domain->is_active ? '' : 'selected' }}>{{ __('app.no') }}</option>
              </select>
            </div>
            <div class="col-md-4 mt-3">
              <label class="form-label">{{__('app.verified')}}</label>
              <select name="is_verified" class="form-select form-select-lg">
                 <option value="0" {{ $tracking_domain->is_verified ? '' : 'selected' }}>{{ __('app.no')}}</option>
                 <option value="1" {{ $tracking_domain->is_verified ? 'selected' : '' }}>{{ __('app.yes') }}</option>
              </select>
            </div>
            <div class="col-md-4 mt-3">
              <label class="form-label">{{__('app.auto_verification')}}</label>
              <select name="auto_verification" class="form-select form-select-lg">
                 <option value="0" {{ $tracking_domain->auto_verification ? '' : 'selected' }}>{{ __('app.no')}}</option>
                 <option value="1" {{ $tracking_domain->auto_verification ? 'selected' : '' }}>{{ __('app.yes') }}</option>
              </select>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('app.close')}}</button>
        <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
      </div>
    </form>
  </div>
</div>