@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script src="{{asset('assets/js/show-password.js')}}"></script>
@endpush

@section('styles')
<style>
.select2-container {
   z-index: 0 !important; /* Below Choices.js but above other elements */
}
</style>
@endsection

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('users.update', $user->id) }}" class="row g-3 mt-0 needs-validation" novalidate>
         @csrf
         @method('PUT')
         <div class="col-md-6">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}"
            aria-label="{{__('app.name')}}" value="{{ $user->name }}"  name="name" required>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.email')}}</label>
            <input type="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ $user->email }}" name="email" required>
         </div>
         <div class="col-md-6">
            <div class="position-relative">
               <label class="form-label">{{__('app.password')}}</label>
               <input id="password"  type="password" class="form-control" placeholder="{{__('app.password')}}" name="password">
               <a href="javascript:void(0);" class="show-password-button text-muted" onclick="createpassword('password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
            </div>
         </div>
         <div class="col-md-6">
            <div class="position-relative">
               <label class="form-label">{{__('app.confirm_password')}}</label>
               <input id="confirm-password" type="password" class="form-control" placeholder="{{__('app.confirm_password')}}" name="confirm-password">
               <a href="javascript:void(0);" class="show-password-button text-muted" onclick="createpassword('confirm-password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
            </div>
         </div>
         <div class="col-12">
            <label class="form-label">{{__('app.address')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.address')}}" name="address"  value="{{ $user->address }}">
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.phone')}}</label>
            <input type="text" class="form-control" name="phone"  value="{{ $user->phone }}">
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.timezone')}}</label>
            <select name="timezone" class="single-select form-select">
               @foreach(\App\Http\Helper\Helper::timeZones() as $key => $timezone)
               <option value="{{ $key }}" {{ ($key == $user->timezone) ? 'selected' : '' }}>{{ $timezone }}</option>
               @endforeach
            </select>
         </div>

         @if(!$profile)
         <div class="col-md-6">
            <label class="form-label">{{__('app.role')}}
               <a href="{{route('roles.create')}}"><i class="bi bi-plus-circle-fill text-primary"></i></a>
            </label>
            <select name="roles" class="form-select form-select-lg" required>
               <option value="">{{__('app.select_role')}}</option>
               @foreach ($roles as $role)
               <option value="{{ $role->name }}" {{ isset($userRole[$role->name]) ? 'selected' : ''}}>
                  {{ $role->display_name }}
               </option>
               @endforeach
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.status')}}</label>
            <select class="form-select form-select-lg" name="is_active">
               <option value="1" {{ $user->is_active ? 'selected' : ''}}>{{__('app.active')}}</option>
               <option value="0" {{ !$user->is_active ? 'selected' : ''}}>{{__('app.in_active')}}</option>
            </select>
         </div>
         @else
         <input type="hidden" name="roles" value="{{Auth::user()->roles->pluck('name')[0] ?? ''}}">
         @endif     
         <div class="col-12">
            <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
            <a href="{{route('users.index')}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@endsection
