<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('imports', function (Blueprint $table) {
            $table->id();

            $table->enum('type', ['contact', 'suppression'])->nullable();
            $table->string('file');
            $table->json('attributes')->nullable();
            $table->unsignedInteger('total');
            $table->unsignedInteger('processed')->default(0);
            $table->unsignedInteger('duplicates')->default(0);
            $table->unsignedInteger('invalids')->default(0);
            $table->unsignedInteger('bounced')->default(0);
            $table->unsignedInteger('suppressed')->default(0);
            $table->unsignedBigInteger('app_id');
            $table->unsignedBigInteger('user_id');
            $table->timestamp('created_at')->useCurrent();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('imports');
    }
};
