<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('emails_pages', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->tinyInteger('order')->unsigned()->default(0);
            $table->string('slug')->nullable();
            $table->enum('type', ['page', 'email'])->default('page');
            $table->text('email_subject')->nullable();
            $table->longText('content')->nullable();
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('emails_pages');
    }
};
