<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sending_servers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('group_id')->nullable();
            $table->string('name');
            $table->string('type')->nullable()->default('php_mail');
            $table->enum('status', ['Active', 'Inactive', 'System Inactive', 'System Paused'])->default('Active');
            $table->text('detail')->nullable();
            $table->text('notification')->nullable();
            $table->string('from_name')->nullable();
            $table->string('from_email')->nullable();
            $table->string('reply_email')->nullable();
            $table->text('tracking_domain')->nullable();
            $table->unsignedInteger('bounce_id')->nullable();
            $table->json('sending_attributes')->nullable();
            $table->json('speed_attributes')->nullable();
            $table->unsignedInteger('total_sent')->default(0);
            $table->unsignedInteger('hourly_sent')->default(0);
            $table->timestamp('hourly_sent_next_timestamp')->nullable();
            $table->unsignedInteger('daily_sent')->default(0);
            $table->timestamp('daily_sent_next_timestamp')->nullable();
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();

            $table->foreign('group_id')->references('id')->on('groups')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sending_servers');
    }
};
