<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('roles', function (Blueprint $table) {
            // guard_name and name is unique so adding for clients
            $table->string('display_name')->after('name')->nullable();
            $table->enum('type', ['user', 'client'])->after('app_id')->default('user');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('roles', function (Blueprint $table) {
            $table->dropColumn('display_name'); // Remove the column if rolling back
            $table->dropColumn('type'); // Remove the column if rolling back
        });
    }
};