<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            Schema::table('users', function (Blueprint $table) {
                $table->dropUnique('users_email_unique'); // Attempt to drop the unique index
            });
        } catch (\Exception $e) {
            // Log the error or ignore it if the index doesn't exist
            logger()->warning("Could not drop index users_email_unique: " . $e->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->unique('email'); // Re-adds the unique index
        });
    }
};
