$(function () {
  'use strict';
  $(".btn-loading").on('click', function() {
    $(this).find("i").addClass("spinner-border spinner-border-sm align-middle");
  });
  $("#checkAll").on('click', function() {
    $('input:checkbox').not(this).prop('checked', this.checked);
  });

  // Fetch all the forms we want to apply custom Bootstrap validation styles to
  var forms = document.querySelectorAll('.needs-validation')

  // Loop over them and prevent submission if there are invalid fields
  Array.prototype.slice.call(forms)
    .forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()

          // remove button loader
          $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
        }

        form.classList.add('was-validated')
      }, false)
    })

  $('.select-all').on('click', function() {
    if($(this).is(':checked')) {
      $('.'+this.value).prop('checked', true);
    } else {
      $('.'+this.value).prop('checked', false);
    }
  });

  $(".single-select").select2({
      dir: "ltr",
       minimumResultsForSearch: Infinity // This disables the search box
     });
    $("#type").change(function () {
      var type = $('#type').val();
      (type == 'radio' || type == 'checkbox' || type == 'dropdown') ? $('#values').show() : $('#values').hide();
    });
    
    $("#option").change(function() {
      var option = $("#option option:selected").val();
      if(option == 'file') {
        $("#section-emails").hide();
        $("#section-file,#info-filesize").show();
      } else if(option == 'write') {
        $("#section-emails").show();
        $("#section-file,#info-filesize").hide();
      }
    });

    $("#resource").change(function() {
      var resource = $("#resource option:selected").val();
      if(resource == 'file') {
        $("#section-emails,#btn-save").hide();
        $("#section-file,#info-filesize,#btn-proceed").show();
      } else {
        $("#section-emails,#btn-save").show();
        $("#section-file,#info-filesize,#btn-proceed").hide();
      }
    });

   $('#api-status').on('change', function() {
      $.ajax({
         url: '/api-status',
         method: 'PUT',
         data: {value: $('#api-status').val()},
         success: function(result) {
           if(result) {
             toastr.success('Saved successfully.');
           } else {
             toastr.error('Found some error(s).');
           }
         }
      });
   });
   $('#copy-api-url').on('click', function() {
     document.getElementById("api-base-url").select();
     document.execCommand("copy");
     toastr.success('Copied successfully!');
   });
   $('#copy-api-key').on('click', function() {
     document.getElementById("api-key").select();
     document.execCommand("copy");
     toastr.success('Copied successfully!');
   });
   
  $('#regenerate-api-key').click(function() {
    swal({
      title: "",
      text: $('#api_msg_regenerate').data('value'),
      type: "warning",
      showCancelButton: true,
      cancelButtonClass: "btn-primary",
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Yes",
      closeOnConfirm: false
    }, function (isConfirm) {
      if(isConfirm) {
        $("#frm-api").submit(); 
      }
    });
  });

  $("#based-on-trigger").change(function() {
    loadBasedOnData($("#based-on-trigger").val(), 'create');
  });


  $('input[name="from_detail"]').on('change', function () {
    if ($(this).val() === 'custom' && $(this).is(':checked')) {
      // Enable validation for custom email fields
      $('#custom_email_data input, #custom_email_data select').attr('required', true);
      $('#custom_email_data').show(); // Show the div
    } else {
      // Disable validation for custom email fields
      $('#custom_email_data input, #custom_email_data select').removeAttr('required');
      $('#custom_email_data').hide(); // Hide the div
    }
  });
});

  function importBulkUpdate(frm) {
    var route = "/list/bulk_update";
    var frm_data = new FormData(frm);
    if($('#file').length){
      var file_data = $('#file').prop('files')[0];
      frm_data.append('file', file_data);
    }

    $.ajax({
      url: route,
      type: 'POST',
      data: frm_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(result) {
        toastr.success($('#msg_update').data('value'));
        $("#btn-import").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      },
      error: function(result) {
        var errors = result.responseJSON.errors;
          for (error in errors) {
            toastr.error(errors[error]);
          }
        $("#btn-import").find("i").removeClass("spinner-border spinner-border-sm align-middle");
        return false;
      }
    });
    return true;
  }

function getAppURL(){
  return window.location.protocol+'//'+window.location.hostname;
}

function destroy(id, route, msg='Are you sure to delete?') {
  swal({
    title: '',
    text: msg,
    type: "warning",
    showCancelButton: true,
    cancelButtonClass: "btn-primary",
    confirmButtonClass: "btn-danger",
    confirmButtonText: "Delete",
    closeOnConfirm: true
  },
  function(){
    var row_id = '#'+'row_'+id;
    $.ajax({
      url: route,
      method: 'DELETE',
      beforeSend: function() {
      },
      success: function(destroy) {
        if(destroy.success) {
          toastr.success(destroy.message);
          $(row_id).fadeOut();
          $('#data').DataTable().ajax.reload(null, false);
        } else {
          toastr.error(destroy.message);
        }
      }
    });
    
  });
}

function destroyMany(route, msg='Are you sure to delete?') {

  if(!$('input:checkbox:checked').length){
   swal({title: '',text:"Please select at least one checkbox."});
   return false;
  }

  var ids = $('input:checkbox:checked').map(function() {
    return this.value;
  }).get();

  swal({
    title: '',
    text: msg,
    type: "warning",
    showCancelButton: true,
    cancelButtonClass: "btn-primary",
    confirmButtonClass: "btn-danger",
    confirmButtonText: "Delete",
    closeOnConfirm: true
  },
  function(){
    $.ajax({
      url: route,
      method: 'DELETE',
      data: {action: 'many', ids: ids},
      success: function(destroy) {
        //console.log(destroy)
        if(destroy) {
          toastr.success('Deleted successfully.');
          $('input:checkbox:checked').map(function() {
            $('#'+'row_'+this.value).fadeOut();
            $('#data').DataTable().ajax.reload(null, false);
            $("#checkAll").prop('checked', false);
          }).get();
        } else {
          toastr.error('Found some error(s).');
        }
      }
    });
  });
}

function viewModal(modal, route) {
  $.ajax({
    url: route,
    method: 'GET',
    success: function(result) {
      $('#modal-data').html(result);
      $('#'+modal).modal('show');
    }
  });
}


function suppressionImport(button, frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    success: function(result) {
      $.ajax({
        url: route,
        method: 'POST',
        data: {fieldMapping: 1},
        beforeSend: function() {
          $("#file").prop('disabled', true);
          $('#fields-mapping').show();
          $('#suppression-fields').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
        },
        success: function(result) {
          $('#suppression-fields').html(result);
          $('#btn-import').show();
          $('#btn-proceed').hide();
        }
      });
    },
    error: function(result) {
      var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      $("#btn-proceed").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    }
  });
  return true;
}

function doSuppressionImport(button, frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);
  frm_data.append('do_import', 1);
  

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    beforeSend: function() {
    },
    success: function(data) {
      $('#fields-mapping').hide();
      $('#btn-import').hide();
      toastr.success(data);
    }
  });
  return true;
}

function deleteGroup($this, msg='Are you sure to delete?') {
  var span = $($this).parent().closest('tr').children('td').children('span');
  var id = span.attr('id');
  var group_name = span.html().replace(/(<([^>]+)>)/ig,"");
  swal({
    title: '',
    text: msg,
    type: "warning",
    showCancelButton: true,
    cancelButtonClass: "btn-danger",
    confirmButtonClass: "btn-primary",
    confirmButtonText: "Proceed",
    closeOnConfirm: true
  },
  function(){
    $('#group-id-old').val(id);
    $('#move-id').val('');
    $('#modal-title-group').html(group_name);
    $('#modal-group-move').modal('show');
  });
}

function eraseGroup($this, route, msg='Are you sure to delete?') {
  var span = $($this).parent().closest('tr').children('td').children('span');
  var id = span.attr('id');
  swal({
    title: '',
    text: msg,
    type: "warning",
    showCancelButton: true,
    cancelButtonClass: "btn-primary",
    confirmButtonClass: "btn-danger",
    confirmButtonText: "Delete",
    closeOnConfirm: true
  },
  function(){
    $.ajax({
      method: 'DELETE',
      url: route,
      data: {id: id, action: 'erase'},
      success: function(destroy) {
        if(destroy) {
          toastr.success('Deleted successfully.');
          $('#data').DataTable().ajax.reload(null, false);
        } else {
          toastr.error('Found some error(s).');
        }
      }
    });
  });
}

function moveGroup() {
  var group_id_new = $('#groups-move').val();
  var group_id_old = $('#group-id-old').val();
  var move_id = $('#move-id').val();
  var route = $('#route-group').val();

  $.ajax({
    method: 'DELETE',
    url: route,
    data: {id: group_id_old, group_id_new: group_id_new, move_id: move_id,  action: 'move'},
    success: function(destroy) {
      $('#modal-group-move').modal('hide');
      toastr.success('Moved successfully.');
      $("#btn-move").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      $('#data').DataTable().ajax.reload(null, false);
    },
    error: function(result) {
    }
  });
}
function move(id, name) {
  $('#move-id').val(id);
  $('#modal-title-group').html(name);
  $('#modal-group-move').modal('show');
}

function emptyList(id, route, msg='Are you sure to empty?') {
  swal({
    title: '',
    text: msg,
    type: "warning",
    showCancelButton: true,
    cancelButtonClass: "btn-primary",
    confirmButtonClass: "btn-danger",
    confirmButtonText: "Empty List",
    closeOnConfirm: true
  },
  function(){
    $.ajax({
      url: route,
      method: 'POST',
      beforeSend: function() {
      },
      success: function(result) {
        if(result) {
          toastr.success('Empty successfully.');
        } else {
          toastr.error('Found some error(s).');
        }
      }
    });
    
  });
}


function loadListCustomFields(list_id, view=null, custom_field_ids=null) {
  $.ajax({
    url: "/lists-custom-fields",
    method: 'GET',
    data: {list_id: list_id, view: view, custom_field_ids: custom_field_ids},
    beforeSend: function() {
      $('#list_custom_fields').html('<div class="col-md-offset-2 col-md-10"><i class="spinner-border text-dark"></i></div>');
    },
    success: function(result) {
      $('#list_custom_fields').html(result);
    }
  });
}

function loadListCustomFieldsWithData() {
  $.ajax({
    url: "/lists-custom-fields",
    method: 'GET',
    data: {list_id: $('#list-id').val(), contact_id: $('#contact-id').val()},
    beforeSend: function() {
      $('#list_custom_fields').html('<div class="col-md-offset-2 col-md-10"><i class="spinner-border text-dark" aria-hidden="true"></i></i></div>');
    },
    success: function(result) {
      $('#list_custom_fields').html(result);
    }
  });
}

function contactsImport(frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    success: function(result) {
      var list_id = $('#lists').val();
      $.ajax({
        url: route,
        method: 'POST',
        data: {fieldMapping: 1, list_id: list_id},
        beforeSend: function() {
          $("#file").prop('disabled', true);
          $('#fields-mapping').show();
        },
        success: function(result) {
          $('#btn-proceed').hide();
          $('#list-custom-fields').html(result);          
          $('#btn-import').show();          
          $("#btn-proceed").find("i").removeClass("spinner-border spinner-border-sm align-middle");
        }
      });
    },
    error: function(result) {
      var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      $("#btn-proceed").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    }
  });
  return true;
}

function doContactsImport(frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);
  frm_data.append('do_import', 1);
  

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    beforeSend: function() {
      $("#lists,#duplicates,#active,#confirmed,#verified,#bounced,#suppressed").prop('disabled', true);
      $('.choices').css('pointer-events', 'none');  // Prevent interaction but keep the dropdown visible
      $('.choices').css('cursor', 'not-allowed');   // Show the forbidden cursor on hover
      $('#btn-import').hide();
      $('#fields-mapping').hide();
      $('#import-contacts').show();
    },
    success: function(id) {
      contactsImportStatus(id);
    }
  });
  return true;
}

function contactsImportStatus(id) {
  var route = "/contacts-import-status/"+id;
  $.ajax({
    url: route,
    type: 'GET',
    success: function(result) {
      var obj = JSON.parse(result);
      var percent = (obj.processed/obj.total)*100;
      var percentage = Math.round(percent)+'%';
      $('.progress-bar').width(percentage).html(percentage);
      $('#total').html(obj.total);
      $('#processed').html(obj.processed);
      $('#duplicates-data').html(obj.duplicates);
      $('#invalids').html(obj.invalids);
      $('#suppressed-data').html(obj.suppressed);
      $('#bounced-data').html(obj.bounced);
      if(percent != 100) {
        if(obj.total != obj.processed) setTimeout(contactsImportStatus(id), 5000);
      }
    }
  });
}

function copyShortcode(code){
  var shortcode = document.getElementById("shortcode-textbox");
  shortcode.value = code;
  shortcode.select();
  document.execCommand("copy");
  toastr.success('Copied successfully!');
}

function validateImap(frm, route) {
  var frm_data = $(frm).serialize();
  $.ajax({
    url: route,
    method: 'GET',
    data: frm_data,
    beforeSend: function() {
      $("#imap-msg").html('');
    },
    success: function(result) {
      $("#validate-imap").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      $("#imap-msg").html(result);
    }
  });
}

function domainVerifications(id, type) {
  var route = "/domain_verfications/"+id+"/"+type;
  $.ajax({
    url: route,
    type: 'GET',
    beforeSend: function() {
      if(type=='all' || type=='dkim') {
        $('#key-'+id).html("<i class='spinner-border spinner-border-sm align-middle'></i>");
      }
      if(type=='all' || type=='spf') {
        $('#spf-'+id).html("<i class='spinner-border spinner-border-sm align-middle'></i>");
      }
      if(type=='all' || type=='dmarc') {
        $('#dmarc-'+id).html("<i class='spinner-border spinner-border-sm align-middle'></i>");
      }
      if(type=='tracking') {
        $('#tracking-'+id).html("<i class='spinner-border spinner-border-sm align-middle'></i>");
      }
    },
    success: function(data) {
      var obj = JSON.parse(data);
      if(type=='all' || type=='dkim') {
        $('#key-'+id).html(obj.key ? '<span class="badge bg-success"><i class="bi bi-check-lg"></i></span>' : '<span class="badge bg-danger"><i class="bi bi-x-lg"></i></span>');
      }
      if(type=='all' || type=='spf') {
        $('#spf-'+id).html(obj.spf ? '<span class="badge bg-success"><i class="bi bi-check-lg"></i></span>' : '<span class="badge bg-danger"><i class="bi bi-x-lg"></i></span>');
      }
      if(type=='all' || type=='dmarc') {
        $('#dmarc-'+id).html(obj.dmarc ? '<span class="badge bg-success"><i class="bi bi-check-lg"></i></span>' : '<span class="badge bg-danger"><i class="bi bi-x-lg"></i></span>');
      }
      if(type=='tracking') {
        $('#tracking-'+id).html(obj.tracking ? '<span class="badge bg-success"><i class="bi bi-check-lg"></i></span>' : '<span class="badge bg-danger"><i class="bi bi-x-lg"></i></span>');
      }
    }
  });
}

function validateDomain(id) {
  domainVerifications(id, 'all');
  setTimeout(function() {
    $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
  }, 3000); // 5000 milliseconds = 5 seconds
}

function sendEmailTest(frm) {
  var frm_data = $(frm).serialize();
  var route = "/send_email_test";
  $.ajax({
    url: route,
    method: 'POST',
    data: frm_data,
    beforeSend: function() {
      $("#msg").html('');
    },
    success: function(result) {
      $("#send-test-email").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      $("#msg").html(result);
    },
    error: function(result) {
      var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      $("#send-test-email").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    }
  });
}

function resetSentCounter(id, msg='Are you sure to clear the sent counter?') {
  swal({
    title: '',
    text: msg,
    type: "warning",
    showCancelButton: true,
    cancelButtonClass: "btn-danger",
    confirmButtonClass: "btn-primary",
    confirmButtonText: "Reset counter",
    closeOnConfirm: true
  },
  function(){
    $.ajax({
      url: "/sending_server/reset_counter/"+id,
      method: 'PUT',
      beforeSend: function() {
      },
      success: function(result) {
        if(result) {
          toastr.success('Counter reset successfully.');
          $('#data').DataTable().ajax.reload(null, false);
        } else {
          var errors = result.responseJSON.errors;
          for (error in errors) {
            toastr.error(errors[error]);
          }
        }
      }
    });
    
  });
}
function insertCKEDITOR(id, route, subject=null) {
  swal({
    title: '',
    text: $('#insert-template-msg').data('value'),
    type: "warning",
    showCancelButton: true,
    cancelButtonClass: "btn-danger",
    confirmButtonClass: "btn-primary",
    confirmButtonText: "Continue",
    closeOnConfirm: true
  }, function (isConfirm) {
    if(isConfirm) {
      CKEDITOR.instances['content_html'].setData('');
      $.get(route+id, function(content_html) {
        content_html = content_html.replace("Relayzo - Email Template", "");
        CKEDITOR.instances['content_html'].insertHtml(content_html);

        // set schedule subject
        if (subject !== null) {
           $('#email_subject').val(subject);
        }
        $('#modal').modal('hide');
      });
    }
  });
}

function loadSendingServerAttributes(type, action, id=null) {
  var route = "/get_sending_server_fields/"+type+"/"+action+"/"+id;
  $.ajax({
    type: "GET",
    url: route,
    beforeSend: function() {
      $('#sending-attributes').show();
      $('#sending-attributes').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
    },
    success: function(result) {
      $('#sending-attributes').html(result);
    }
  });
}

$("#type").change(function() {
    var type = $("#type").val();
    loadSendingServerAttributes(type, 'create');
  });

  $("#speed").change(function() {
    var value = $("#speed").val();
    if (value === 'limited') {
      $("#speed-attributes").show('slow');
    } else {
      $("#speed-attributes").hide('slow');
    }
  });

  function runLimitedToUnlimited(id, msg){
  swal({
    title: 'This action is irreversible.',
    text: msg,
    type: "warning",
    showCancelButton: true,
    confirmButtonClass: "btn-success",
    cancelButtonClass: "btn-danger",
    confirmButtonText: "Run Without Limit",
    closeOnConfirm: true
  },
  function(){
    $.ajax({
      url: "/limited_to_unlimited",
      method: 'PUT',
      data: {id: id},
      success: function(result) {
        toastr.success('Update successfully.');
        $('#data').DataTable().ajax.reload(null, false);
      }
    });
  });
}
function set2xSpeed(id, limit, initial_limit, msg){
  swal({
    title: "The updated speed cannot be reduced once applied.",
    text: msg,
    type: "warning",
    showCancelButton: true,
    confirmButtonClass: "btn-success",
    cancelButtonClass: "btn-danger",
    confirmButtonText: "Double the Speed",
    closeOnConfirm: true
  },
  function(){
    $.ajax({
      url: "/set_2x_speed",
      method: 'PUT',
      data: {id: id, initial_limit:initial_limit, limit:limit},
      success: function(result) {
        toastr.success('Update successfully.');
        $('#data').DataTable().ajax.reload(null, false);
      }
    });
  });
}
function playCampaign(id) {
  $.ajax({
    url: '/update_schedule_campaign_status/'+id,
    method: 'PUT',
    data: {status: 'Paused'},
    success: function(result) {
      $('#pause-'+id).hide();
      $('#play-'+id).show();
      $('#status-'+id).html($('#paused').data('value'));
      toastr.error($('#paused-msg').data('value'));
    }
  });
  
}
function pauseCampaign(id) {
  $.ajax({
    url: '/update_schedule_campaign_status/'+id,
    method: 'PUT',
    data: {status: 'Resume'},
    success: function(result) {
      $('#play-'+id).hide();
      $('#pause-'+id).show();
      $('#status-'+id).html($('#running').data('value'));
      toastr.success($('#running-msg').data('value'));
    }
  });
}
function copyCampaign(id, msg) {
  swal({
    title: '',
    text: msg,
    type: "warning",
    showCancelButton: true,
    confirmButtonClass: "btn-success",
    cancelButtonClass: "btn-danger",
    confirmButtonText: "Yes",
    closeOnConfirm: true
  },
  function(){
    location.href = "/copy_schedule/"+id;
  });
}

function bouncesImport(frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    success: function(result) {
      $.ajax({
        url: route,
        method: 'POST',
        data: {fieldMapping: 1},
        beforeSend: function() {
          $("#file").prop('disabled', true);
          $('#fields-mapping').show();
          $('#bounce-fields').html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
        },
        success: function(result) {
          $('#bounce-fields').html(result);
          $('#btn-import').show();
          $('#btn-proceed').hide();
        }
      });
    },
    error: function(result) {
      var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      $("#btn-proceed").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    }
  });
  return true;
}

function doBouncesImport(frm, route) {
  var frm_data = new FormData(frm);
  var file_data = $('#file').prop('files')[0];
  frm_data.append('file', file_data);
  frm_data.append('do_import', 1);
  

  $.ajax({
    url: route,
    type: 'POST',
    data: frm_data,
    cache: false,
    contentType: false,
    processData: false,
    beforeSend: function() {
    },
    success: function(data) {
      $('#fields-mapping').hide();
      $('#btn-import').hide();
      toastr.success('Import successfully.');
      $('#data').DataTable().ajax.reload(null, false);
    }
  });
  return true;
}

function exportBounced(route, msg, msg_success) {
    swal({
    title: '',
    text: msg,
    type: "warning",
    showCancelButton: true,
    cancelButtonClass: "btn-danger",
    confirmButtonClass: "btn-primary",
    confirmButtonText: "Export",
    closeOnConfirm: true
  },
  function(){
      $.get(route, function( data ) {
        toastr.success(msg_success);
      });
  });
}

function detailStats(id, type) {
  var route = '/detail/stat/campaign/'+id+'/'+type;
  $('#tab_stat_campaign_'+type).html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
  $.get(route, function( data ) {
    $('#tab_stat_campaign_'+type).html(data);
  });
}

$('#stat-export').on('click', function() {
  $('#export-download').empty();
  var route = $('#stat-export').data('route');
  $.get(route, function(result) {
    var route = $('#export-download').data('route');
    $('#export-download').html('<a class="link-info" href="'+route+'">'+$('#export-download').data('value')+'</a>');
    $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
  });
});

function detailStatsTriggers(id, type) {
  var route = '/detail/stat/trigger/'+id+'/'+type;
  $('#tab_stat_trigger_'+type).html('<div class="spinner-border text-dark" role="status"><spam class="visually-hidden"></span></div>');
  $.get(route, function( data ) {
    $('#tab_stat_trigger_'+type).html(data);
  });
}

function sendHelp(frm) {
  var frm_data = $(frm).serialize();
  var route = "/help_send";
  $.ajax({
    url: route,
    method: 'POST',
    data: frm_data,
    beforeSend: function() {
      $("#msg").html('');
    },
    success: function(result) {
      $("#send-test-email").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      $("#msg").html(result);
    },
    error: function(result) {
      var errors = result.responseJSON.errors;
        for (error in errors) {
          toastr.error(errors[error]);
        }
      $("#send-test-email").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    }
  });
}

function moveCopySegment(button, route) {
  var frm_data = $('#frm-list').serialize();
  $.ajax({
    method: 'PUT',
    url: route,
    data: frm_data,
    success: function(msg) {
      toastr.success(msg);
      $('#modal').modal('hide');
      $('#data').DataTable().ajax.reload(null, false);
    }
  });
}
function segmentExport(route) {
  $.ajax({
    method: 'PUT',
    data: {action: 'Export'},
    url: route,
    success: function(msg) {
      toastr.success(msg);
      $('#data').DataTable().ajax.reload(null, false);
    }
  });
}

function segmentStop(route) {
  $.ajax({
    method: 'PUT',
    url: route,
    success: function(msg) {
      $('#data').DataTable().ajax.reload(null, false);
    }
  });
}

// Handle date changes (shared logic for onReady and onChange)
function handleDateChange(localDate, dateStr) {
    if (localDate) {
        const timeZone = document.querySelector("#timezone").value;

        // Convert the selected date to UTC based on the specified timezone
        const utcDate = convertToUTC(localDate, timeZone);

        // Save the UTC date to the hidden field (db_send_datetime)
        document.querySelector("#db_send_datetime").value = utcDate;

        // Keep the selected date visible in the calendar field
        document.querySelector("#send_datetime").value = dateStr;
    }
}

// Convert a local date to UTC based on the specified timezone
function convertToUTC(localDate, timeZone) {
    const options = {
        timeZone: timeZone,
        year: "numeric",
        month: "2-digit",
        day: "2-digit",
        hour: "2-digit",
        minute: "2-digit",
        second: "2-digit",
        hourCycle: "h23",
    };

    const formatter = new Intl.DateTimeFormat("en-US", options);
    const formattedDate = formatter.formatToParts(localDate);

    const year = formattedDate.find((p) => p.type === "year").value;
    const month = formattedDate.find((p) => p.type === "month").value;
    const day = formattedDate.find((p) => p.type === "day").value;
    const hour = formattedDate.find((p) => p.type === "hour").value;
    const minute = formattedDate.find((p) => p.type === "minute").value;
    const second = formattedDate.find((p) => p.type === "second").value;

    // Construct the UTC ISO date string
    return new Date(`${year}-${month}-${day}T${hour}:${minute}:${second}`).toISOString();
}

function loadBasedOnData(type, action, id=null) {
  var route = getAppURL()+"/get_based_on_data/"+type+"/"+action+"/"+id;
  $.ajax({
    type: "GET",
    url: route,
    beforeSend: function() {
      $('#based-on-data').html('<div class="form-group"><div class="col-md-12">'+
        '<i class="spinner-border text-dark"></i></div>');
    },
    success: function(result) {
      $('#based-on-data').html(result);

      // Reinitialize Choices.js for the newly loaded element
        $("#based-on-data #list_ids,#segment_ids,#schedule_campaign_stat_ids").each(function() {
            // Destroy existing Choices instance (if any)
            if ($(this).data('choices')) {
                $(this).data('choices').destroy();
            }

            // Apply Choices.js
            new Choices(this, {
                removeItemButton: true,
                allowHTML: true,
                shouldSort: false,
            });
        });

        // Reinitialize Flatpickr for newly loaded elements
        $("#send_datetime .flatpickr").each(function() {
            // Check if Flatpickr is already initialized and destroy it
            if ($(this)[0]._flatpickr) {
                $(this)[0]._flatpickr.destroy();
            }

            // Initialize Flatpickr
            $(this).flatpickr({
                enableTime: false,
                time_24hr: false,  // Use 12-hour format with AM/PM
                dateFormat: "Y-m-d", // User-friendly format
                disableMobile: true
            });
        });
    }
  });
}

function loadBasedOnAction(type, action, id=null) {
  var route = getAppURL()+"/get_based_on_data/"+type+"/"+action+"/"+id;
  $.ajax({
    type: "GET",
    url: route,
    beforeSend: function() {
      $('#action-data').html('<div class="form-group"><div class="col-md-12">'+
        '<i class="spinner-border text-dark"></i></div>');
    },
    success: function(result) {
      $('#action-data').html(result);
    }
  });
}