$(function() {
	'use strict';
	$('.repeater-contact').repeater({
		show: function () {
			$(this).slideDown();
		},
		hide: function (deleteElement) {
			if(confirm("Are you sure you want to delete the condition?")) {
				$(this).slideUp(deleteElement);
			}
		},
		isFirstItemUndeletable: true
	});

	flatpickr("#datetime", {
    enableTime: false,
    time_24hr: false, // Use 12-hour format with AM/PM
    dateFormat: "Y-m-d", // User-friendly format
    disableMobile: true,
	});
});
function loadContactAction($this, placeholder_values='Use comma for multiples') {
  var contact_filter_action = $this.name.replace('name', 'action');
  var contact_filter_value = $this.name.replace('name', 'value');
  var select_action =  $("[name='"+contact_filter_action+"']");
  var select_value =  $("[name='"+contact_filter_value+"']");

  if($this.value == '') {
    select_action.replaceWith(
      "<select class='form-control' name='"+contact_filter_action+"'></select>"
    );
    select_value.replaceWith(
      "<select class='form-control' name='"+contact_filter_value+"'></select>"
    );
  } else if($this.value == 'email') {
    select_action.replaceWith(
      "<select class='form-select' name='"+contact_filter_action+"'>"+
      "<option value='is'>is</option>"+
      "<option value='is_not'>is not</option>"+
      "<option value='contain'>contain</option>"+
      "<option value='not_contain'>doesn\'t</option>"+
      "</select>"
    );
    select_value.replaceWith(
      "<input type='text' class='form-control' placeholder='"+placeholder_values+"' name='"+contact_filter_value+"' >"
    );
  } else {
    select_action.replaceWith(
      "<select class='form-select' name='"+contact_filter_action+"'>"+
      "<option value='is'>is</option>"+
      "<option value='is_not'>is not</option>"+
      "</select>"
    );

    if($this.value == 'status') {
      select_value.replaceWith(
        "<select class='form-select' name='"+contact_filter_value+"'>"+
        "<option value='active'>Active</option>"+
        "<option value='inactive'>Inactive</option>"+
        "</select>"
      );
    } else if($this.value == 'source') {
      select_value.replaceWith(
        "<select class='form-select' name='"+contact_filter_value+"'>"+
        "<option value='app'>App</option>"+
        "<option value='import'>Import</option>"+
        "</select>"
      );
    }
  }
}

function loadDate($this) {
  var date_filter_value = $this.name.replace('action', 'value');
  var date_value =  $("input[name='"+date_filter_value+"']");
  flatpickr(date_value, {
    enableTime: false,
    time_24hr: false, // Use 12-hour format with AM/PM
    dateFormat: "Y-m-d", // User-friendly format
    disableMobile: true,
  });
}