$(function() {
  'use strict';
  $('#btn-update').on('click', function() {
    swal({
      title: '',
      text: $('#update-proceed-msg').data('value'),
      type: "warning",
      showCancelButton: true,
      cancelButtonText: "Cancel",
      cancelButtonClass: "btn-danger",
    	confirmButtonClass: "btn-primary",
      confirmButtonText: "Yes",
      closeOnConfirm: true
    },
    function(isConfirm){
	    if(isConfirm) {
	      $.ajax({
	        url: '/update_app',
	        method: 'POST',
	        data: {do_update: 1},
	        beforeSend: function() {
	          $('#msg').html($('#update-warning-msg').data('value'));
	          $('#msg').addClass('text-danger');
	          $('#msg').removeClass('text-success');
	        },
	        success: function(result) {
	          if(!result.verify) {
	            $('#msg').addClass('text-danger');
	            $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
	          } else {
	          	$(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
	          	$('#msg').removeClass('text-danger');
	            $('#msg').addClass('text-success');
	            $('#btn-update').hide();
	          }
	          if(result.message) {
	            $('#msg').html(result.message);
	          }
	          else {
	            $('#msg').html(result);
	          }
	        }
	      });
	  	} else {
	      $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
	  	}
    });
  });
});