@extends('layouts.login')

@section('content')
<p class="mb-4 text-muted op-7 fw-normal text-center">{{ __('app.welcome_back') }}</p>
<form method="POST" action="{{ route('login') }}">
    @csrf
    <div class="row gy-3">
        <div class="col-xl-12 mb-2">
            <label for="email" class="form-label text-default">{{ __('app.login_username') }}</label>
            <input id="email" type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus placeholder="{{ __('app.login_username') }}">
            @error('email')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>
        <div class="col-xl-12 mb-2">
            <label for="password" class="form-label text-default d-block">{{ __('app.loing_password') }}<a tabindex="-1" href="{{ route('password.request') }}" class="float-end fw-normal text-muted">{{ __('app.forgot_password') }} ?</a></label>
            <div class="position-relative">
                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="current-password">
                @error('password')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
                <a tabindex="-1" href="javascript:void(0);" class="show-password-button text-muted" onclick="createpassword('password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
            </div>
            <div class="mt-2">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
                    <label class="form-check-label text-muted fw-normal" for="defaultCheck1">
                        {{ __('app.remember_me') }}
                    </label>
                </div>
            </div>
        </div>
    </div>                        
    <div class="d-grid mt-4">
        <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{ __('app.sign_in') }} </button>
    </div>
</form>
@endsection
