@extends('layouts.login')

@section('content')
<p class="mb-4 text-muted op-7 fw-normal text-center">{{ __('app.reset_password') }}</p>
<form method="POST" action="{{ route('password.update') }}">
<input type="hidden" name="token" value="{{ $token }}">
    @csrf
    <div class="row gy-3">
        <div class="col-xl-12 mb-2">
            <label for="email" class="form-label text-default">{{ __('app.login_username') }}</label>
            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>
            @error('email')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>
        <div class="col-xl-12 mb-2">
            <label for="password" class="form-label text-default d-block">{{ __('app.loing_password') }}</label>
            <div class="position-relative">
                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
                @error('password')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
                <a tabindex="-1" href="javascript:void(0);" class="show-password-button text-muted" onclick="createpassword('password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
            </div>
        </div>
        <div class="col-xl-12 mb-2">
            <label for="password" class="form-label text-default d-block">{{ __('app.confirm_password') }}</label>
            <div class="position-relative">
                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                <a tabindex="-1" href="javascript:void(0);" class="show-password-button text-muted" onclick="createpassword('password-confirm',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
            </div>
        </div>
    </div>                        
    <div class="d-grid mt-4">
        <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{ __('app.reset_password') }} </button>
    </div>
</form>
@endsection
