@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script src="{{asset('components/ckeditor/ckeditor.js')}}"></script>
<script src="{{asset('components/ckeditor/plugins/mc_uploader/plugin.js')}}"></script>
<script src="{{asset('assets/js/campaign.js')}}"></script>
@endpush

@section('styles')
<style type="text/css">
  .modal-body {
    overflow: scroll !important;
   }
</style>
@endsection

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('contents.update', $emails_pages->id) }}" class="row g-3 mt-0 needs-validation" novalidate>
         @csrf
         @method('PUT')
         <div class="col-md-12">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ $emails_pages->name }}" name="name" disabled>
         </div>
         @if($emails_pages->type == 'email')
         <div class="col-md-12">
            <label class="form-label">{{__('app.subject')}}</label>
            <a tabindex="0" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="top" data-bs-custom-class="header-primary" title="Subject Help" data-bs-content="You can use all shortcodes in subject line."><i class="bi bi-question-square-fill text-primary"></i></a>
            <input type="text" class="form-control" placeholder="{{__('app.subject')}}" value="{{ $emails_pages->email_subject }}" name="email_subject" required>
         </div>
         @endif
         <div class="col-md-12">
            <label class="form-label">{{__('app.content')}} <span class="ps-5"></span><button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('shortcodes') }}');">{{ __('app.shortcodes') }}</button></label>
            <textarea class="form-control" id="content_html" name="content" rows="10">{{\App\Http\Helper\Helper::decodeString($emails_pages->content) }}</textarea>
         </div>
         
         <div class="col-12">
            <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
            <a href="{{route('contents.index', ['type' => $emails_pages->type])}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@include('includes.modal')
@endsection