@php
if(isset($client_package_lists) && $client_package_lists == 1) {
    $client_lists = \App\Http\Helper\Helper::getClientAttributeValue(\Auth::user()->app_id, 'list_ids');
}
@endphp

@if(isset($popup) && $popup == 1)
<script type="text/javascript">
    "use strict";
    document.getElementById('modal').addEventListener('shown.bs.modal', function () {
      const multipleLists = new Choices(document.getElementById('list_ids'), {
        removeItemButton: true,
        dropdownParent: document.getElementById('modal') // Attach to modal
      });
    });

</script>
@else
  @push('scripts')
  <script type="text/javascript">
    let multipleLists;
    (function () {
      "use strict";
      multipleLists = new Choices(document.getElementById('list_ids'), {
        searchEnabled: true,
        removeItemButton: true,
        placeholder: true, // Optional: Show placeholder text
      });
    })();
  </script>
  @endpush
@endif
<select name="list_ids[]" class="form-select form-select-lg" id="list_ids" @if(isset($multiple) && $multiple == 1) multiple @endif  @if(isset($required)) required @endif>
  <option value="">{{__('app.select_list')}}</option>
  @if(!empty($client_lists))
    @foreach(\App\Models\Lists::groupListsClient($client_lists) as $group)
      <optgroup label="{{ $group->name }}">
        @foreach($group->lists as $list)
          @if(in_array($list->id, $client_lists))
            <option value="{{ $list->id }}" {{ !empty($list_ids) && in_array($list->id, $list_ids) ? 'selected="selected"' : '' }}>{{ $list->name }} ({{$list->total_contacts}})</option>
          @endif
        @endforeach
      </optgroup>
    @endforeach
  @endif
  @foreach(\App\Models\Lists::groupLists() as $group)
    <optgroup label="{{ $group->name }}">
      @foreach($group->lists as $list)
        <option value="{{ $list->id }}" {{ ((!empty($list_ids) && in_array($list->id, $list_ids)) || (isset($list_id) && $list->id == $list_id)) ? 'selected="selected"' : '' }}>{{$list->name}} ({{$list->total_contacts ?? 0}})</option>
      @endforeach
    </optgroup>
  @endforeach
</select>
@if(isset($required))
<div class="invalid-feedback">Please select at least one option.</div>
@endif