@php $client_sending_servers = \App\Http\Helper\Helper::getClientAttributeValue(\Auth::user()->app_id, 'sending_server_ids') @endphp

@if($popup)
<script type="text/javascript">
(function () {
    "use strict";
    document.getElementById('modal').addEventListener('shown.bs.modal', function () {
      const multipleSendingServers = new Choices(document.getElementById('sending_server_ids'), {
        allowHTML: true,
        removeItemButton: true,
        dropdownParent: document.getElementById('modal') // Attach to modal
      });
    });
});
</script>
@else
  @push('scripts')
  <script type="text/javascript">
    let multipleSendingServers;
    (function () {
      "use strict";
      multipleSendingServers = new Choices(document.getElementById('sending_server_ids'), {
        searchEnabled: true,
        removeItemButton: true,        
      });
    })();
  </script>
  @endpush
@endif
<select name="sending_server_ids[]" class="form-select form-select-lg" id="sending_server_ids" @if(isset($multiple) && $multiple == 1) multiple @endif  @if(isset($required)) required @endif>
  <option value="">{{__('app.select_delivery_server')}}</option>
  @if(!empty($client_sending_servers))
    @foreach(\App\Models\SendingServer::groupSendingServersClient($client_sending_servers) as $group)
      <optgroup label="{{ $group->name }}">
        @foreach($group->sendingServers as $sending_server)
          @if(in_array($sending_server->id, $client_sending_servers))
            <option value="{{ $sending_server->id }}" {{ !empty($sending_server_ids) && in_array($sending_server->id, $sending_server_ids) == $sending_server->id ? 'selected="selected"' : '' }}>{{ $sending_server->name }}</option>
          @endif
        @endforeach
      </optgroup>
    @endforeach
  @endif
  @foreach(\App\Models\SendingServer::groupSendingServers() as $group)
    <optgroup label="{{ $group->name }}">
      @foreach($group->sendingServers as $sending_server)
        <option value="{{ $sending_server->id }}" {{ ((!empty($sending_server_ids) && in_array($sending_server->id, $sending_server_ids)) || (isset($sending_server_id) && $sending_server->id == $sending_server_id)) ? 'selected="selected"' : '' }}>{{$sending_server->name}}</option>
      @endforeach
    </optgroup>
  @endforeach
</select>
<div class="invalid-feedback">Please select at least one option.</div>