<header class="app-header sticky" id="header">

    <!-- Start::main-header-container -->
    <div class="main-header-container container-fluid">

        <!-- Start::header-content-left -->
        <div class="header-content-left">

            <!-- Start::header-element -->
            <div class="header-element">
                <div class="horizontal-logo">
                    <a href="{{route('dashboard')}}" class="header-logo">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="desktop-logo">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="toggle-dark">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="desktop-dark">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="toggle-logo">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="toggle-white">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="desktop-white">
                    </a>
                </div>
            </div>
            <!-- End::header-element -->

            <!-- Start::header-element -->
            <div class="header-element mx-lg-0 mx-2">
                <a aria-label="Hide Sidebar" class="sidemenu-toggle header-link animated-arrow hor-toggle horizontal-navtoggle" data-bs-toggle="sidebar" href="javascript:void(0);"><span></span></a>
            </div>
            <!-- End::header-element -->


            <!-- Start::header-element -->
            <div class="header-element d-md-block d-none">
                <!-- Start::header-link -->
                <span class="top-bar-timezone">
                    <span id="time_zone" style="display: none;">{{isset($time_zone) ? $time_zone : 'Europe/London'}}</span>
                    <div id="clock"></div>
                </span>
                <!-- End::header-link -->
            </div>
            <!-- End::header-element -->

        </div>
        <!-- End::header-content-left -->

        <!-- Start::header-content-right -->
        <ul class="header-content-right">
            <!-- Start::header-element -->
            <li class="header-element header-theme-mode">
                <!-- Start::header-link|layout-setting -->
                <a href="javascript:void(0);" class="header-link layout-setting">
                    <span class="light-layout">
                        <!-- Start::header-link-icon -->
                        <i class="bi bi-moon w-6 h-6 header-link-icon"></i>
                        <!-- End::header-link-icon -->
                    </span>
                    <span class="dark-layout">
                        <!-- Start::header-link-icon -->
                        <i class="bi bi-sun w-6 h-6 header-link-icon"></i>
                        <!-- End::header-link-icon -->
                    </span>
                </a>
                <!-- End::header-link|layout-setting -->
            </li>
            <!-- End::header-element -->
            <!-- Start::header-element -->
            <li class="header-element notifications-dropdown d-xl-block d-none dropdown">
                <!-- Start::header-link|dropdown-toggle -->
                <a href="javascript:void(0);" class="header-link dropdown-toggle" data-bs-toggle="dropdown" data-bs-auto-close="outside" id="messageDropdown" aria-expanded="false">
                    <i class="bi bi-bell w-6 h-6 header-link-icon"></i>
                    @if(count($notifications))
                    <span class="header-icon-pulse bg-primary2 rounded pulse pulse-secondary"></span>
                    @endif
                </a>
                <!-- End::header-link|dropdown-toggle -->
                <!-- Start::main-header-dropdown -->
                <div class="main-header-dropdown dropdown-menu dropdown-menu-end" data-popper-placement="none">
                    <div class="p-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <p class="mb-0 fs-15 fw-medium">{{__('app.notifications')}}</p>
                            <span class="badge bg-secondary text-fixed-white" id="notifiation-data">{{count($notifications)}} {{__('app.unread')}}</span>
                        </div>
                    </div>
                    <div class="dropdown-divider"></div>
                    <ul class="list-unstyled mb-0" id="header-notification-scroll">
                        @foreach($notifications as $notification)
                        @switch($notification->type)
                        @case('export')
                        @php ($icon = 'bi-download')
                        @php ($title = __('app.download'))
                        @break
                        @case('import')
                        @php ($icon = 'bi-check')
                        @php ($title = __('app.import'))
                        @break
                        @default
                        @php ($icon = 'bi-bell')
                        @php ($title = __('app.read'))
                        @endswitch
                        <li class="dropdown-item">
                            <div class="d-flex align-items-center">                                
                                <div class="flex-grow-1 d-flex align-items-center justify-content-between">
                                    <div>
                                        <p class="mb-0 fw-medium"><a href="{{ route('notification.read', ['id' => $notification->id]) }}">{{$title}}</a></p>
                                        <div class="text-dark fw-normal fs-12 header-notification-text text-truncate">{{ $notification->name}}</div>
                                        <div class="fw-normal fs-10 text-dark op-8">{{ App\Http\Helper\Helper::datetimeDisplay($notification->created_at)}}</div>
                                    </div>
                                    <div><i class="bi {{$icon}}"></i></div>
                                </div>
                            </div>
                        </li>
                        @endforeach
                    </ul>

                    @if(count($notifications))
                    <div class="p-3 empty-header-item1 border-top">
                        <div class="d-grid">
                            <a href="{{ route('notification.read.all') }}" class="btn btn-danger btn-wave">{{__('app.clear_all')}}</a>
                        </div>
                    </div>
                    @endif                 
                </div>
                <!-- End::main-header-dropdown -->
            </li>
            <!-- End::header-element -->

            <!-- Start::header-element -->
            <li class="header-element header-fullscreen">
                <!-- Start::header-link -->
                <a onclick="openFullscreen();" href="javascript:void(0);" class="header-link">
                    <i class="bi bi-fullscreen w-6 h-6 full-screen-open header-link-icon"></i>
                    <i class="bi bi-fullscreen-exit w-6 h-6 full-screen-close header-link-icon d-none"></i>
                </a>
                <!-- End::header-link -->
            </li>
            <!-- End::header-element -->

            <!-- Start::header-element -->
            <li class="header-element dropdown">
                <!-- Start::header-link|dropdown-toggle -->
                <a href="javascript:void(0);" class="header-link dropdown-toggle" id="mainHeaderProfile" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
                    <i class="bi bi-person-circle w-6 h-6 header-link-icon"></i>
                </a>
                <!-- End::header-link|dropdown-toggle -->
                <ul class="main-header-dropdown dropdown-menu pt-0 overflow-hidden header-profile-dropdown dropdown-menu-end" aria-labelledby="mainHeaderProfile">
                    <li>
                        <div class="dropdown-item text-center border-bottom">
                            <span>
                                {{ Auth::user()->name ?? '' }}
                            </span>
                            <span class="d-block fs-12 text-muted">{{  Auth::user()->roles->pluck('display_name')[0] ?? '' }}</span>
                        </div>
                    </li>
                    <li><a class="dropdown-item d-flex align-items-center" href="{{ route('profile')}}"><i class="fe fe-user p-1 rounded-circle bg-primary-transparent me-2 fs-16"></i>{{__('app.profile')}}</a></li>
                    <li class="border-top bg-light">
                        <a class="dropdown-item d-flex align-items-center" href="javascript:;" onclick="viewModal('modal', '{{route('help')}}');"><i class="fe fe-help-circle p-1 rounded-circle bg-primary-transparent set me-2 fs-16"></i>{{__('app.help')}}</a></li>
                    <li><a class="dropdown-item d-flex align-items-center" href="{{ route('logout') }}"  
                        onclick="event.preventDefault();
                        document.getElementById('logout-form').submit();">
                        <i class="fe fe-lock p-1 rounded-circle bg-primary-transparent ut me-2 fs-16"></i>{{__('app.logout')}}</a></li>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="display-none">
                            @csrf
                        </form>
                    </ul>
                </li>  
                <!-- End::header-element -->

                <!-- Start::header-element -->
                <li class="header-element">
                    <!-- Start::header-link|switcher-icon -->
                    <a href="javascript:void(0);" class="header-link switcher-icon" data-bs-toggle="offcanvas" data-bs-target="#switcher-canvas">
                        <span class="bi bi-palette w-6 h-6 header-link-icon"></span>
                    </a>
                    <!-- End::header-link|switcher-icon -->
                </li>
                <!-- End::header-element -->

            </ul>
            <!-- End::header-content-right -->

        </div>
        <!-- End::main-header-container -->
</header>