<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="ltr" data-nav-layout="vertical" data-theme-mode="light" data-header-styles="light" data-menu-styles="dark" data-toggled="close">
<head>
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - {{ $app_name ?? 'Relayzo'  }}</title>
    <link rel="icon" href="{{asset('images/app/favicon.ico')}}" type="image/x-icon">
    <link id="style" href="{{asset('assets/libs/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet" >
    <link href="{{asset('assets/css/styles.css')}}" rel="stylesheet" >
    <link href="{{asset('assets/css/icons.css')}}" rel="stylesheet" >
    <link href="{{asset('assets/css/sweetalert.css')}}" rel="stylesheet" >
    <link href="{{asset('assets/css/toastr.min.css')}}" rel="stylesheet" >
    <link href="{{asset('assets/libs/node-waves/waves.min.css')}}" rel="stylesheet" > 
    <link href="{{asset('assets/libs/simplebar/simplebar.min.css')}}" rel="stylesheet" >
    <link rel="stylesheet" href="{{asset('assets/libs/@simonwep/pickr/themes/nano.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/libs/choices.js/public/assets/styles/choices.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/libs/flatpickr/flatpickr.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/libs/select2/css/select2.min.css')}}">
    <link href="{{asset('assets/css/custom.css')}}" rel="stylesheet" >
    <style>
    .page-header-breadcrumb{
        margin-block: 1em !important;
    }
    </style>
    @yield('styles')   
</head>
<body>
    <!-- Start Switcher -->
    @include('includes.switcher')
    <!-- End Switcher -->

    <!-- Loader -->
    <div id="loader" >
        <img src="{{asset('assets/images/media/loader.svg')}}" alt="">
    </div>
    <!-- Loader -->
    <div class="page">
         <!-- app-header -->
         @include('includes.header')
        <!-- /app-header -->

        <!-- Start::app-sidebar -->
        @include('includes.sidebar')
        <!-- End::app-sidebar -->

        <!-- Start::app-content -->
        <div class="main-content app-content">
            <div class="container-fluid">
                @include('includes.breadcrumbs')
                @yield('content')
            </div>
        </div>
        <!-- End::app-content -->

        <!-- Footer Start -->
        @include('includes.footer')
        <!-- Footer End -->
    </div>

<!-- Scroll To Top -->
<div class="scrollToTop">
    <span class="arrow"><i class="ti ti-arrow-narrow-up fs-20"></i></span>
</div>
<div id="responsive-overlay"></div>
<!-- Scroll To Top -->

<script src="{{asset('assets/js/jquery.min.js')}}"></script>
<script src="{{asset('assets/js/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/toastr.min.js')}}"></script>
<script src="{{asset('assets/libs/choices.js/public/assets/scripts/choices.min.js')}}"></script>
<script src="{{asset('assets/js/main.js')}}"></script>
<script src="{{asset('assets/libs/@popperjs/core/umd/popper.min.js')}}"></script>
<script src="{{asset('assets/libs/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
<script src="{{asset('assets/js/defaultmenu.min.js')}}"></script>
<script src="{{asset('assets/libs/node-waves/waves.min.js')}}"></script>
<script src="{{asset('assets/js/sticky.js')}}"></script>
<script src="{{asset('assets/libs/simplebar/simplebar.min.js')}}"></script>
<script src="{{asset('assets/js/simplebar.js')}}"></script>
<script src="{{asset('assets/libs/@simonwep/pickr/pickr.es5.min.js')}}"></script>
<script src="{{asset('assets/libs/datatables/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/libs/select2/js/select2.min.js')}}"></script>
<script src="{{asset('assets/libs/flatpickr/flatpickr.min.js')}}"></script>
<script src="{{asset('assets/js/custom.js')}}"></script>
<script src="{{asset('assets/js/custom-switcher.min.js')}}"></script>
<script src="{{asset('assets/js/moment.js')}}"></script>
<script src="{{asset('assets/js/moment-timezone-with-data.js')}}"></script>
<script src="{{asset('assets/js/clock.js')}}"></script>
<script src="{{asset('assets/js/datatable.init.js')}}"></script>
<script src="{{asset('assets/js/app.js')}}"></script>
@stack('scripts')
<script type="text/javascript">
$.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});
</script>
@include('includes.modal')
</body>
</html>
