@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
(function () {
  'use strict';
  const multipleDefault = new Choices(document.getElementById('custom_fields'), {
    allowHTML: true,
    removeItemButton: true,
  });
})();
</script>
@endpush

@section('styles')
<style type="text/css">
  #group_id + .select2-container {
    z-index: 0 !important;
  }
</style>
@endsection

@section('content')
<div class="card custom-card">
  <div class="card-body">
    <label class="col-md-12"><h6 class="text-primary">{{__('app.general_info')}}</h6></label>
    <form method="POST" action="{{ route('lists.store') }}" class="row g-3 mt-0 needs-validation" novalidate>
      @csrf
      <div class="col-md-6 mt-1">
        <label class="form-label">{{__('app.group')}}
          <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_lists')])}}');">
            <i class="bi bi-plus-circle-fill text-primary"></i>
          </a>
        </label>
        <select name="group_id" class="single-select form-select" id="group_id" required>
          <option value="">{{__('app.select_group')}}</option>
          @foreach($groups as $id => $group_name)
          <option value="{{ $id }}" {{ old('group_id') == $id ? 'selected' : '' }}>{{$group_name}}</option>
          @endforeach
        </select>
        <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
      </div>
      <div class="col-md-6 mt-1">
        <label class="form-label">{{__('app.name')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ old('name') }}" name="name" required>
      </div>
      <div class="col-md-12">
        <label class="form-label">{{__('app.description')}}</label>
        <textarea class="form-control" placeholder="{{__('app.description')}}" row="3" name="description">{{ old('description') }}</textarea>
      </div>
      <div class="col-md-12">
        <label class="form-label">{{__('app.custom_field')}}
          <a href="javascript:;" onclick="viewModal('modal', '{{route('custom_fields.create')}}');" tabindex="-1">
            <i class="bi bi-plus-circle-fill text-primary"></i>
          </a>
          <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.custom_field')}}"
            data-bs-content="{{__('app.list_custom_fields')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
            </a>
        </label>
        <select name="custom_fields[]" id="custom_fields" class="form-control" multiple>
          @foreach($custom_fields as $id => $custom_field)
          <option value="{{ $id }}" {{ in_array($id, old('custom_fields', [])) ? 'selected' : '' }}>{{ $custom_field }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">{{__('app.double_optin')}}</label>
        <select name="double_optin" class="form-select form-select-lg">
          <option value="No" {{ old('double_optin', 'No') == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>
          <option value="Yes" {{ old('double_optin') == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">{{__('app.welcome_email')}} <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.welcome_email')}}"
            data-bs-content="{{__('app.list_welcome_email')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
            </a></label>
        <select name="welcome_email" class="form-select form-select-lg">
          <option value="No" {{ old('welcome_email') == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>
          <option value="Yes" {{ old('welcome_email') == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">{{__('app.unsub_email')}} <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.unsub_email')}}"
            data-bs-content="{{__('app.list_unsub_email')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
            </a></label>
        <select name="unsub_email" class="form-select form-select-lg">
          <option value="No" {{ old('unsub_email') == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>
          <option value="Yes" {{ old('unsub_email') == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">{{__('app.notify_email')}} <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.notify_email')}}"
            data-bs-content="{{__('app.list_notify_email')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
            </a></label>
        <input type="text" class="form-control" placeholder="{{__('app.notify_email')}}" value="{{ old('notify_email') }}" name="notify_email">
      </div>
      
      <label class="col-md-12 mt-4"><h6 class="text-primary">{{__('app.from_detail')}} <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.from_detail')}}"
            data-bs-content="{{__('app.list_from_detail')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
            </a></h6></label>
      <div class="col-md-3 mt-1">
        <label class="form-label">{{__('app.from_name')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="{{ old('from_name') }}" name="from_name" required>
      </div>

      <div class="col-md-6 mt-1">
        <label class="form-label">{{__('app.from_email')}}
          <a href="{{route('sending_domains.index')}}" tabindex="-1">
            <i class="bi bi-plus-circle-fill text-primary"></i>
          </a>
        </label>
        <div class="input-group">
          <div style="width: 35%;">
            <input type="text" name="from_email_part1" class="form-control" placeholder="{{__('app.from_email_example')}}" value="{{ old('from_email_part1') }}" required >
          </div>
          <span class="input-group-text">@</span>
          <select name="from_email_part2" class="form-select" required>
            <option value="">{{__('app.select_domain')}}</option>
            @foreach($sending_domains as $sending_domain)
              <option value="{{ $sending_domain->domain }}" {{ old('from_email_part2') == $sending_domain->domain ? 'selected' : '' }}>{{ $sending_domain->domain }}</option>
            @endforeach
          </select>
        </div>
      </div>

      <div class="col-md-3 mt-1">
        <label class="form-label">{{__('app.reply_email')}}</label>
        <input type="email" class="form-control" placeholder="{{__('app.reply_email')}}" value="{{ old('reply_email') }}" name="reply_email" required>
      </div>
      <div class="col-12">
        <button type="submit" name="save_exit" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_exit')}}</button>
        <button type="submit" name="save_continue" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_continue')}}</button>
        <a href="{{route('lists.index')}}">
         <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
        </a>
      </div>
    </form>
  </div>
</div>
@include('includes.modal')
@endsection