@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
loadSendingServerAttributes($("#type").val(), 'edit',0);
</script>
@endpush

@section('styles')
<style type="text/css">
   .div-webhook-url,.process-reports-div{
      display: none !important;
   }
</style>
@endsection

@section('content')
<ul class="nav nav-pills" id="pills-tab" role="tablist">
   <li class="nav-item" role="presentation">
      <button class="nav-link active" id="pills-general-tab" data-bs-toggle="pill" data-bs-target="#pills-general" type="button" role="tab" aria-controls="pills-general" aria-selected="true">{{__('app.general')}}</button>
   </li>
   <li class="nav-item" role="presentation">
      <button class="nav-link" id="pills-mail-tab" data-bs-toggle="pill" data-bs-target="#pills-mail" type="button" role="tab" aria-controls="pills-mail" aria-selected="false">{{__('app.mail')}}
      @if(empty($settings->from_name) || empty($settings->from_email))
      <span class="text-danger">*</span>
      @endif
   </button>
   </li>
   <li class="nav-item" role="presentation">
      <button class="nav-link" id="pills-tracking-tab" data-bs-toggle="pill" data-bs-target="#pills-tracking" type="button" role="tab" aria-controls="pills-tracking" aria-selected="false">{{__('app.tracking')}}</button>
   </li>
</ul>
<form method="POST" action="{{ route('settings.update', config('custom.app_id')) }}" class="row g-3 mt-0 needs-validation" novalidate enctype="multipart/form-data">
   <div class="tab-content" id="pills-tabContent">
      @csrf
      @method('PUT')
      <div class="tab-pane fade show active" id="pills-general" role="tabpanel" aria-labelledby="pills-general-tab">
         <div class="card custom-card">
            <div class="card-body">
               <div class="row">
                  <div class="col-md-12">
                     <label class="form-label">{{__('app.application_cron')}} <i class='bo bi-copy bi-1x text-primary' onclick="copyShortcode('{{ \App\Http\Helper\Helper::getCronCommand() }}')" style="cursor: pointer !important;"></i></label>
                     <input type="text" class="form-control" value="{{ \App\Http\Helper\Helper::getCronCommand() }}" id="shortcode-textbox" readonly>
                  </div>
                  <div class="col-md-6">
                     <label class="form-label mt-3">{{__('app.license_key')}}</label>
                     <input type="text" class="form-control" value="{{ $settings->license_key ?? '' }}" readonly>
                  </div>
                  <div class="col-md-6">
                     <label class="form-label mt-3">{{__('app.application_version')}}</label>
                     <input type="text" class="form-control" value="{{ $settings->current_version ?? '' }}" readonly>
                  </div>
                  <div class="col-md-6 mt-3">
                     <label class="form-label">{{__('app.app_name')}}</label>
                     <input type="text" class="form-control" placeholder="{{__('app.app_name')}}"
                     aria-label="{{__('app.app_name')}}" value="{{ $settings->app_name ?? '' }}"  name="app_name" required>
                  </div>
                  <div class="col-md-6 mt-3">
                     <label class="form-label">{{__('app.app_url')}}</label>
                     <input type="text" class="form-control" placeholder="{{__('app.app_url')}}" value="{{ $settings->app_url ?? '' }}" name="app_url" required>
                  </div>
                  <div class="col-md-6">
                     <label class="form-label mt-3">{{__('app.server_ip')}}</label>
                     <input type="text" class="form-control" value="{{$_SERVER['SERVER_ADDR']}}" readonly>
                  </div>
                  <div class="col-md-6 mt-3">
                     <label class="form-label">{!! \App\Http\Helper\Helper::getMaxFileSize() !!}</label>
                     <div class="input-group">                     
                        <input type="number" class="form-control" name="max_allowed_file_size" value="{{ json_decode($settings->attributes)->max_file_size ?? '2'}}" min="1" required>
                        <div class="input-group-text">
                           <a href="javascript:;" tabindex="-1"><i>MB</i></a>
                        </div>
                     </div>
                  </div>
                  <div class="col-md-6 mt-3">
                     <label class="form-label">{{__('app.login_page_logo')}} <small>(.png)</small></label>
                     <input class="form-control" name="file_login_page_logo" type="file" id="file">
                  </div>
                  <div class="col-md-6 mt-3">
                     <label class="form-label">{{__('app.application_logo')}} <small>(.png)</small></label>
                     <input class="form-control" name="file_application_logo" type="file" id="file">
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div class="tab-pane fade" id="pills-mail" role="tabpanel" aria-labelledby="pills-mail-tab">
         <div class="card custom-card">
            <div class="card-body">
               <div class="row">
                  <div class="col-md-12">
                     <label class="form-label">{{__('app.delivery_server')}}</label>
                     <select name="type" id="type" class="single-select form-control" >
                        @foreach(\App\Http\Helper\Helper::sendingServers() as $type => $value)
                        <option value="{{ $type }}" {{ $type == $settings->sending_type ? 'selected="selected"' : '' }}>{{ $value }}</option>
                        @endforeach
                     </select>
                  </div>               
                  <div class="col-md-6 mt-3">
                     <label class="form-label">{{__('app.from_name')}}</label>
                     <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="{{ $settings->from_name ?? '' }}" name="from_name" required>
                  </div>
                  <div class="col-md-6 mt-3">
                     <label class="form-label">{{__('app.from_email')}}
                        <a href="{{route('sending_domains.index')}}" tabindex="-1">
                           <i class="bi bi-plus-circle-fill text-primary"></i>
                        </a>
                     </label>
                     <div class="input-group">
                        <div style="width: 35%;">
                           <input type="text" name="from_email_part1" class="form-control" placeholder="{{__('app.from_email_example')}}" value="{{strstr($settings->from_email, '@', true)}}" required >
                        </div>
                        <span class="input-group-text">@</span>
                        @php
                        $from_email_domain = '';
                        if(!empty($settings->from_email))
                        $from_email_domain = explode('@', $settings->from_email)[1];
                        @endphp
                        <select name="from_email_part2" class="form-select" required>
                           <option value="">{{__('app.select_domain')}}</option>
                           @foreach(\App\Models\SendingDomain::getSendingDomains() as $sending_domain)
                           <option value="{{ $sending_domain->domain }}" {{ ($from_email_domain == $sending_domain->domain) ? 'selected="selected"' : '' }}>{{ $sending_domain->domain }}</option>
                           @endforeach
                        </select>
                     </div>
                  </div>
                  <div class="col-md-12 mt-3">
                     <div id="sending-attributes"></div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div class="tab-pane fade" id="pills-tracking" role="tabpanel" aria-labelledby="pills-tracking-tab">
         <div class="card custom-card">
            <div class="card-body">
               <div class="row">              
                  <div class="col-md-12">
                     @if(!file_exists(config('custom.path_maxmind_geo_db')))
                     <div class="text-danger">
                        {!! str_replace('[path]', config('custom.path_maxmind_geo_db'), __('app.geo_file_missing_msg')) !!}
                        <br>
                        {!! str_replace('[path]', config('custom.path_maxmind_geo_db'), __('app.geo_file_download_msg')) !!}
                     </div>
                     @endif
                  </div>
                  <div class="col-md-12">
                     <label class="form-label">{{__('app.tracking')}}</label>
                     <select name="tracking" class="form-select">
                        <option value="enabled" {{ ($settings->tracking == 'enabled') ? 'selected' : '' }}>{{ __('app.enabled') }}</option>
                        <option value="disabled" {{ ($settings->tracking == 'disabled') ? 'selected' : '' }}>{{ __('app.disabled') }}</option>
                     </select>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="col-12 mt-3">
      <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
   </div>
</form>
@endsection
