@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
        "columnDefs": [{"sortable": false, "targets": [0, 3]}],
        "order": [[ 1, "desc" ]],
        "lengthMenu": [[50, 100, 200], [50, 100, 200]],
        "ajax": $('#route-group-lists').data('route'),
    });
    table.on('draw', function() {
        $('#data_paginate a').addClass('btn btn-primary me-1');
        $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <a href="javascript:;" onclick="viewModal('modal', '{{route('spintags.create')}}');"><button id="addRow" class="btn btn-primary" style="margin: 0px; display: none;">{{__('app.add_new_spintag')}}</button></a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle btn-sm" data-bs-toggle="dropdown" aria-expanded="false">{{__('app.actions')}}</button>
                                <ul class="dropdown-menu" style="">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('spintags.destroy', [0]) }}')"><i class="bi bi-trash"></i> {{ __('app.delete') }}</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.shortcodes') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-group-lists" data-route="{{ route('get.spintags') }}"></span>
@include('includes.datatables')
@endsection
