@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<link href="{{asset('assets/css/schedule.css')}}" rel="stylesheet" >
@endsection

@push('scripts')
<script>
loadBasedOnData('list', 'create');
loadBasedOnAction('send_campaign', 'create');
</script>
@endpush

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('triggers.store') }}" class="row g-3 mt-0 needs-validation" novalidate>
         @csrf
         <div class="col-md-6">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}"
            aria-label="{{__('app.name')}}" value="{{ old('name') }}"  name="name" required>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.status')}}</label>
            <select class="form-select form-select-lg" name="is_active">
               <option value="1">{{__('app.active')}}</option>
               <option value="0">{{__('app.in_active')}}</option>
            </select>
         </div>
         <div class="col-md-12">
           <label class="form-label">{{__('app.detail')}}</label>
           <textarea class="form-control" placeholder="{{__('app.detail')}}" row="3" name="detail">{{ old('detail') }}</textarea>
         </div>
         <div class="col-md-12">
            <label class="form-label">{{ __('app.based_on') }}</label>
            <select class="form-select form-select-lg" name="based_on" id="based-on-trigger">
               <option value="list">{{ __('app.trigger_based_on_list') }}</option>
               <option value="segment">{{ __('app.trigger_based_on_segment') }}</option>
               <option value="campaign">{{ __('app.trigger_based_on_campaign') }}</option>
               <option value="date">{{ __('app.trigger_based_on_date') }}</option>               
            </select>
         </div>
         <div id="based-on-data"></div>
        <div id="action-data"></div>
         <div class="col-md-12">
           <label class="form-label">{{__('app.delivery_servers')}}
             <a tabindex="-1" role="button"
             data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
             data-bs-content="{{__('app.packages_delivery_servers')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
             </a>
           </label>
           @include('includes.dropdown_sending_server', ['popup' => 0, 'multiple' => 1, 'required' => 1])
         </div>
         <div class="col-md-12 mt-3">
              <label class="form-label">{{__('app.from_detail')}}</label><br>
              <input name="from_detail" class="form-check-input ms-2" type="radio" checked="checked" value="sending_server"> {{__('app.as_defined_for_sending_server')}} &nbsp;
              <input name="from_detail" class="form-check-input ms-2" type="radio" value="list"> {{__('app.as_defined_for_list')}} &nbsp;
              <input name="from_detail" class="form-check-input ms-2" type="radio" value="custom"> {{__('app.custom')}}
          </div>
          <div class="row mt-3" id="custom_email_data" style="display: none;">
              <div class="col-md-3">
                 <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="" name="from_name">
              </div>
              <div class="col-md-5">
                 <div class="input-group">
                    <div style="width: 35%;">
                      <input type="text" name="from_email_part1" value="" class="form-control" placeholder="{{__('app.from_email_example')}}">
                    </div>
                    <span class="input-group-text">@</span>
                    <select name="from_email_part2" class="form-select">
                      <option value="">{{__('app.select_domain')}}</option>
                      @foreach(\App\Models\SendingDomain::getSendingDomains() as $sending_domain)
                        <option value="{{ $sending_domain->domain }}">{{ $sending_domain->domain }}</option>
                      @endforeach
                    </select>
                  </div>
              </div>
              <div class="col-md-4">
                 <input type="email" class="form-control" placeholder="{{__('app.reply_email')}}" value="" name="reply_email">
              </div>
          </div>
         <div class="col-md-12">
            <label class="form-label">{{ __('app.sending_speed') }}</label>
            <select class="form-select form-select-lg" name="sending_speed" id="speed">
               <option value="unlimited">{{ __('app.unlimited') }}</option>
               <option value="limited">{{ __('app.limited') }}</option>
            </select>
         </div>
         <div class="row" id="speed-attributes" style="display: none;">
            <div class="col-md-6 mt-3" >
                <input type="number" class="form-control" name="limit" id="limit" value="1000" min="1" placeholder="1000">
            </div>
            <div class="col-md-6 mt-3" >
                <select name="duration" id="duration" class="form-select form-select-lg" >
                  <option value="hour">{{ __('app.hourly') }}</option>
                </select>
            </div>
          </div>
         <div class="col-12">
            <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.create')}}</button>
            <a href="{{route('triggers.index')}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@endsection
