@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<link href="{{asset('assets/css/schedule.css')}}" rel="stylesheet" >
@endsection

@push('scripts')
<script>
loadBasedOnData('{{$trigger->based_on}}', 'edit', '{{$trigger->id}}');
loadBasedOnAction('{{$trigger->action}}', 'edit', '{{$trigger->id}}');
</script>
@endpush

@php $attributes = json_decode($trigger->attributes); @endphp

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('triggers.update', $trigger->id) }}" class="row g-3 mt-0 needs-validation" novalidate>
         @csrf
         @method('PUT')
         <div class="col-md-6">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}"
            aria-label="{{__('app.name')}}" value="{{ $trigger->name }}"  name="name" required>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.status')}}</label>
            <select class="form-select form-select-lg" name="is_active">
               <option value="1" {{ $trigger->is_active ? 'selected' : '' }}>{{__('app.active')}}</option>
               <option value="0" {{ !$trigger->is_active ? 'selected' : '' }}>{{__('app.in_active')}}</option>
            </select>
         </div>
         <div class="col-md-12">
           <label class="form-label">{{__('app.detail')}}</label>
           <textarea class="form-control" placeholder="{{__('app.detail')}}" row="3" name="detail">{{ $trigger->detail }}</textarea>
         </div>
         <div class="col-md-12">
            <label class="form-label">{{ __('app.based_on') }}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}"
            aria-label="{{__('app.name')}}" value="{{ ucfirst($trigger->based_on) }}" disabled>
            <input type="hidden" name="based_on" value="{{$trigger->based_on}}">
         </div>
         <div id="based-on-data"></div>
        <div id="action-data"></div>
         <div class="col-md-12">
           <label class="form-label">{{__('app.delivery_servers')}}
             <a tabindex="-1" role="button"
             data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
             data-bs-content="{{__('app.packages_delivery_servers')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
             </a>
           </label>
           @php $sending_server_ids = json_decode($attributes->sending_server_ids); @endphp
           @include('includes.dropdown_sending_server', ['popup' => 0, 'multiple' => 1, 'required' => 1])
         </div>
         <div class="col-md-12 mt-3">
              <label class="form-label">{{__('app.from_detail')}}</label><br>
              <input name="from_detail" class="form-check-input ms-2" type="radio" value="sending_server" {{ $attributes->from_detail == 'sending_server' ? 'checked' : '' }}> {{__('app.as_defined_for_sending_server')}} &nbsp;
              <input name="from_detail" class="form-check-input ms-2" type="radio" value="list" {{ $attributes->from_detail == 'list' ? 'checked' : '' }}> {{__('app.as_defined_for_list')}} &nbsp;
              <input name="from_detail" class="form-check-input ms-2" type="radio" value="custom" {{ $attributes->from_detail == 'custom' ? 'checked' : '' }}> {{__('app.custom')}}
          </div>
          <div class="row mt-3" id="custom_email_data" style="{{ $attributes->from_detail == 'custom' ? '' : 'display: none;' }}">
              @php
              if($attributes->from_detail == 'custom') {
                $form_detail_custom = json_decode($attributes->from_detail_custom);
                $from_email_domain = explode('@', $form_detail_custom->from_email)[1];
              }
              @endphp
              <div class="col-md-3">
                 <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="{{$form_detail_custom->from_name ?? ''}}" name="from_name">
              </div>
              <div class="col-md-5">
                 <div class="input-group">
                    <div style="width: 35%;">
                      <input type="text" name="from_email_part1" value="{{($attributes->from_detail == 'custom') ? strstr($form_detail_custom->from_email, '@', true) : ''}}" class="form-control" placeholder="{{__('app.from_email_example')}}">
                    </div>
                    <span class="input-group-text">@</span>
                    <select name="from_email_part2" class="form-select">
                      <option value="">{{__('app.select_domain')}}</option>
                      @foreach(\App\Models\SendingDomain::getSendingDomains() as $sending_domain)
                        <option value="{{ $sending_domain->domain }}" {{ ($attributes->from_detail == 'custom' && $from_email_domain == $sending_domain->domain) ? 'selected="selected"' : '' }}>{{ $sending_domain->domain }}</option>
                      @endforeach
                    </select>
                  </div>
              </div>
              <div class="col-md-4">
                 <input type="email" class="form-control" placeholder="{{__('app.reply_email')}}" value="{{$form_detail_custom->reply_email ?? ''}}" name="reply_email">
              </div>
          </div>
         <div class="col-md-12">
            <label class="form-label">{{ __('app.sending_speed') }}</label>
            <select class="form-select form-select-lg" name="sending_speed" id="speed">
               <option value="unlimited" {{ $attributes->sending_speed == 'unlimited' ? 'selected="selected"' : '' }}>{{ __('app.unlimited') }}</option>
               <option value="limited" {{ $attributes->sending_speed == 'limited' ? 'selected="selected"' : '' }}>{{ __('app.limited') }}</option>
            </select>
         </div>
         <div class="row" id="speed-attributes" style="{{ $attributes->sending_speed == 'limited' ? '' : 'display: none;' }}">
            <div class="col-md-6 mt-3" >
                <input type="number" class="form-control" name="limit" id="limit" value="{{ $attributes->limit ?? '1000' }}" min="1" placeholder="1000">
            </div>
            <div class="col-md-6 mt-3" >
                <select name="duration" id="duration" class="form-select form-select-lg" >
                  <option value="hour" {{ $attributes->duration == 'hour' ? 'selected="selected"' : '' }}>{{ __('app.hourly') }}</option>
                </select>
            </div>
          </div>
         <div class="col-12">
            <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
            <a href="{{route('triggers.index')}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@endsection
