@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
$(function () {
  var datatable = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [0, 5]}],
    "order": [[0, "DESC"]],
    "lengthMenu": [[50, 100], [50, 100]],
    "ajax": $('#route-triggers').data('route'),
  });
  $("#modal").on("hidden.bs.modal", function () {
    datatable.ajax.reload(null, false); // user paging is not reset on reload
  });
});
</script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <a href="{{route('triggers.create')}}"><button id="addRow" class="btn btn-primary" style="margin: 0px; display: none;">{{__('app.add_new_trigger')}}</button></a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle btn-sm" data-bs-toggle="dropdown" aria-expanded="false">{{__('app.actions')}}</button>
                                <ul class="dropdown-menu" style="">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('triggers.destroy', [0]) }}')"><i class="bi bi-trash"></i> {{ __('app.delete') }}</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.name') }}</th>
          <th>{{ __('app.based_on') }}</th>
          <th>{{ __('app.active') }}</th>
          <th>{{ __('app.created') }}</th>
          <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-triggers" data-route="{{ route('get.triggers') }}"></span>
@include('includes.datatables')
@endsection
